/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AccessCheck;
import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.AutoReleaseLock;
import com.github.marschall.memoryfilesystem.CurrentGroup;
import com.github.marschall.memoryfilesystem.CurrentUser;
import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.FileAttributeViews;
import com.github.marschall.memoryfilesystem.InitializingFileAttributeView;
import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.FileSystemException;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class MemoryEntryAttributes {
    private long lastModifiedTime;
    private long lastAccessTime;
    private long creationTime;
    private final Map<String, InitializingFileAttributeView> additionalViews;
    private final ReadWriteLock lock;
    private final BasicFileAttributeView basicFileAttributeView = this.newBasicFileAttributeView();
    private final MemoryFileSystem fileSystem;

    MemoryEntryAttributes(EntryCreationContext context) {
        long now;
        this.fileSystem = context.fileSystem;
        this.lock = new ReentrantReadWriteLock();
        this.lastAccessTime = now = this.getNow();
        this.lastModifiedTime = now;
        this.creationTime = now;
        if (context.additionalViews.isEmpty()) {
            this.additionalViews = Collections.emptyMap();
        } else if (context.additionalViews.size() == 1) {
            InitializingFileAttributeView view = this.instantiate(context.firstView(), context);
            this.additionalViews = Collections.singletonMap(view.name(), view);
        } else {
            this.additionalViews = new HashMap<String, InitializingFileAttributeView>(context.additionalViews.size());
            for (Class<? extends FileAttributeView> viewClass : context.additionalViews) {
                if (viewClass == FileOwnerAttributeView.class) continue;
                InitializingFileAttributeView view = this.instantiate(viewClass, context);
                this.additionalViews.put(view.name(), view);
                if (!FileOwnerAttributeView.class.isAssignableFrom(viewClass)) continue;
                this.additionalViews.put("owner", view);
            }
        }
    }

    abstract BasicFileAttributeView newBasicFileAttributeView();

    AutoRelease readLock() {
        return AutoReleaseLock.autoRelease(this.lock.readLock());
    }

    AutoRelease writeLock() {
        return AutoReleaseLock.autoRelease(this.lock.writeLock());
    }

    FileTime lastModifiedTime() {
        return FileTime.fromMillis(this.lastModifiedTime);
    }

    FileTime lastAccessTime() {
        return FileTime.fromMillis(this.lastAccessTime);
    }

    FileTime creationTime() {
        return FileTime.fromMillis(this.creationTime);
    }

    long getNow() {
        return System.currentTimeMillis();
    }

    private UserPrincipal getCurrentUser() {
        UserPrincipal user = CurrentUser.get();
        if (user == null) {
            return this.fileSystem.getUserPrincipalLookupService().getDefaultUser();
        }
        return user;
    }

    private GroupPrincipal getCurrentGroup() {
        return CurrentGroup.get();
    }

    private InitializingFileAttributeView instantiate(Class<? extends FileAttributeView> viewClass, EntryCreationContext context) {
        if (viewClass == PosixFileAttributeView.class) {
            return new MemoryPosixFileAttributeView(this, context);
        }
        if (viewClass == DosFileAttributeView.class) {
            return new MemoryDosFileAttributeView(this, context);
        }
        if (viewClass == UserDefinedFileAttributeView.class) {
            return new MemoryUserDefinedFileAttributeView(this);
        }
        if (viewClass == AclFileAttributeView.class) {
            return new MemoryAclFileAttributeView(this, context);
        }
        throw new IllegalArgumentException("unknown file attribute view: " + viewClass);
    }

    void initializeAttributes(MemoryEntryAttributes other) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.getInitializingFileAttributeView().initializeFrom(other.getBasicFileAttributeView());
            for (InitializingFileAttributeView view : this.additionalViews.values()) {
                view.initializeFrom(other.additionalViews);
            }
        }
    }

    void initializeRoot() {
        try (AutoRelease lock = this.readLock();){
            for (InitializingFileAttributeView view : this.additionalViews.values()) {
                view.initializeRoot();
            }
        }
    }

    void modified() {
        long now;
        this.lastAccessTime = now = this.getNow();
        this.lastModifiedTime = now;
    }

    void accessed() {
        this.lastAccessTime = this.getNow();
    }

    void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws AccessDeniedException {
        try (AutoRelease lock = this.writeLock();){
            this.checkAccess(AccessMode.WRITE);
            if (lastModifiedTime != null) {
                this.lastModifiedTime = lastModifiedTime.toMillis();
            }
            if (lastAccessTime != null) {
                this.lastAccessTime = lastAccessTime.toMillis();
            }
            if (createTime != null) {
                this.creationTime = createTime.toMillis();
            }
        }
    }

    <A extends FileAttributeView> A getFileAttributeView(Class<A> type) {
        try (AutoRelease lock = this.readLock();){
            if (type == BasicFileAttributeView.class) {
                BasicFileAttributeView basicFileAttributeView = this.getBasicFileAttributeView();
                return (A)basicFileAttributeView;
            }
            String name = null;
            if (type == FileOwnerAttributeView.class) {
                if (this.additionalViews.containsKey("posix")) {
                    name = "posix";
                } else if (this.additionalViews.containsKey("acl")) {
                    name = "acl";
                }
            } else {
                name = FileAttributeViews.mapAttributeView(type);
            }
            if (name == null) {
                throw new UnsupportedOperationException("file attribute view" + type + " not supported");
            }
            FileAttributeView view = this.additionalViews.get(name);
            if (view != null) {
                FileAttributeView fileAttributeView = view;
                return (A)fileAttributeView;
            }
            throw new UnsupportedOperationException("file attribute view" + type + " not supported");
        }
    }

    <A extends BasicFileAttributes> A readAttributes(Class<A> type) throws IOException {
        try (AutoRelease lock = this.readLock();){
            if (type == BasicFileAttributes.class) {
                BasicFileAttributes basicFileAttributes = this.getBasicFileAttributeView().readAttributes();
                return (A)basicFileAttributes;
            }
            String viewName = FileAttributeViews.mapFileAttributes(type);
            if (viewName != null) {
                FileAttributeView view = this.additionalViews.get(viewName);
                if (view instanceof BasicFileAttributeView) {
                    BasicFileAttributes basicFileAttributes = ((BasicFileAttributeView)view).readAttributes();
                    return (A)basicFileAttributes;
                }
                throw new UnsupportedOperationException("file attributes " + type + " not supported");
            }
            throw new UnsupportedOperationException("file attributes " + type + " not supported");
        }
    }

    void checkAccess(AccessMode ... modes) throws AccessDeniedException {
        try (AutoRelease lock = this.readLock();){
            AccessMode unsupported = this.getUnsupported(modes);
            if (unsupported != null) {
                throw new UnsupportedOperationException("access mode " + (Object)((Object)unsupported) + " is not supported");
            }
            for (InitializingFileAttributeView attributeView : this.additionalViews.values()) {
                if (!(attributeView instanceof AccessCheck)) continue;
                AccessCheck accessCheck = (AccessCheck)((Object)attributeView);
                accessCheck.checkAccess(modes);
            }
        }
    }

    void checkAccess(AccessMode mode) throws AccessDeniedException {
        try (AutoRelease lock = this.readLock();){
            AccessMode unsupported = this.getUnsupported(mode);
            if (unsupported != null) {
                throw new UnsupportedOperationException("access mode " + (Object)((Object)unsupported) + " is not supported");
            }
            for (InitializingFileAttributeView attributeView : this.additionalViews.values()) {
                if (!(attributeView instanceof AccessCheck)) continue;
                AccessCheck accessCheck = (AccessCheck)((Object)attributeView);
                accessCheck.checkAccess(mode);
            }
        }
    }

    private AccessMode getUnsupported(AccessMode ... modes) {
        for (AccessMode mode : modes) {
            if (mode == AccessMode.READ || mode == AccessMode.WRITE || mode == AccessMode.EXECUTE) continue;
            return mode;
        }
        return null;
    }

    private AccessMode getUnsupported(AccessMode mode) {
        if (mode != AccessMode.READ && mode != AccessMode.WRITE && mode != AccessMode.EXECUTE) {
            return mode;
        }
        return null;
    }

    private InitializingFileAttributeView getInitializingFileAttributeView() {
        return (InitializingFileAttributeView)((Object)this.basicFileAttributeView);
    }

    BasicFileAttributeView getBasicFileAttributeView() {
        return this.basicFileAttributeView;
    }

    static Set<PosixFilePermission> toSet(int mask) {
        EnumSet<PosixFilePermission> set = EnumSet.noneOf(PosixFilePermission.class);
        for (PosixFilePermission permission : PosixFilePermission.values()) {
            int flag = 1 << permission.ordinal() & mask;
            if (flag == 0) continue;
            set.add(permission);
        }
        return set;
    }

    abstract long size();

    static int toMask(Set<PosixFilePermission> permissions) {
        int mask = 0;
        for (PosixFilePermission permission : permissions) {
            mask |= 1 << permission.ordinal();
        }
        return mask;
    }

    static final class MemoryFileAttributes
    extends MemoryEntryFileAttributes {
        private final long size;

        MemoryFileAttributes(Object fileKey, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime, long size) {
            super(fileKey, lastModifiedTime, lastAccessTime, creationTime);
            this.size = size;
        }

        @Override
        public boolean isRegularFile() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return this.size;
        }
    }

    class MemoryFileAttributesView
    extends MemoryEntryFileAttributesView {
        MemoryFileAttributesView() {
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            try (AutoRelease lock = MemoryEntryAttributes.this.readLock();){
                FileTime lastModifiedTime = MemoryEntryAttributes.this.lastModifiedTime();
                FileTime lastAccessTime = MemoryEntryAttributes.this.lastAccessTime();
                FileTime creationTime = MemoryEntryAttributes.this.creationTime();
                MemoryFileAttributes memoryFileAttributes = new MemoryFileAttributes(MemoryEntryAttributes.this, lastModifiedTime, lastAccessTime, creationTime, MemoryEntryAttributes.this.size());
                return memoryFileAttributes;
            }
        }
    }

    static final class MemorySymbolicLinkAttributes
    extends MemoryEntryFileAttributes {
        MemorySymbolicLinkAttributes(Object fileKey, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime) {
            super(fileKey, lastModifiedTime, lastAccessTime, creationTime);
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return true;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }
    }

    class MemorySymbolicLinkAttributesView
    extends MemoryEntryFileAttributesView {
        MemorySymbolicLinkAttributesView() {
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            try (AutoRelease lock = MemoryEntryAttributes.this.readLock();){
                FileTime lastModifiedTime = MemoryEntryAttributes.this.lastModifiedTime();
                FileTime lastAccessTime = MemoryEntryAttributes.this.lastAccessTime();
                FileTime creationTime = MemoryEntryAttributes.this.creationTime();
                MemorySymbolicLinkAttributes memorySymbolicLinkAttributes = new MemorySymbolicLinkAttributes(MemoryEntryAttributes.this, lastModifiedTime, lastAccessTime, creationTime);
                return memorySymbolicLinkAttributes;
            }
        }
    }

    static final class MemoryDirectoryFileAttributes
    extends MemoryEntryFileAttributes {
        MemoryDirectoryFileAttributes(Object fileKey, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime) {
            super(fileKey, lastModifiedTime, lastAccessTime, creationTime);
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }
    }

    class MemoryDirectoryFileAttributesView
    extends MemoryEntryFileAttributesView {
        MemoryDirectoryFileAttributesView() {
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            try (AutoRelease lock = MemoryEntryAttributes.this.readLock();){
                FileTime creationTime = MemoryEntryAttributes.this.creationTime();
                FileTime lastModifiedTime = MemoryEntryAttributes.this.lastModifiedTime();
                FileTime lastAccessTime = MemoryEntryAttributes.this.lastAccessTime();
                MemoryDirectoryFileAttributes memoryDirectoryFileAttributes = new MemoryDirectoryFileAttributes(MemoryEntryAttributes.this, lastModifiedTime, lastAccessTime, creationTime);
                return memoryDirectoryFileAttributes;
            }
        }
    }

    static class MemoryUserDefinedFileAttributeView
    extends DelegatingFileAttributesView
    implements UserDefinedFileAttributeView,
    BasicFileAttributeView {
        private Map<String, byte[]> values;

        MemoryUserDefinedFileAttributeView(MemoryEntryAttributes attributes) {
            super(attributes);
        }

        @Override
        public BasicFileAttributes readAttributes() {
            throw new UnsupportedOperationException("readAttributes");
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            MemoryUserDefinedFileAttributeView other = (MemoryUserDefinedFileAttributeView)selfAttributes;
            if (other.values == null) {
                this.values = null;
            } else {
                this.values = new HashMap<String, byte[]>(other.values.size());
                for (Map.Entry<String, byte[]> entry : other.values.entrySet()) {
                    this.values.put(entry.getKey(), (byte[])entry.getValue().clone());
                }
            }
        }

        private Map<String, byte[]> getValues() {
            if (this.values == null) {
                this.values = new HashMap<String, byte[]>(3);
            }
            return this.values;
        }

        @Override
        public String name() {
            return "user";
        }

        @Override
        public List<String> list() {
            try (AutoRelease lock = this.attributes.readLock();){
                if (this.values == null) {
                    List<String> list = Collections.emptyList();
                    return list;
                }
                Set<String> keys = this.getValues().keySet();
                ArrayList<String> arrayList = new ArrayList<String>(keys);
                return arrayList;
            }
        }

        @Override
        public int size(String name) throws IOException {
            try (AutoRelease lock = this.attributes.readLock();){
                byte[] value = this.getValue(name);
                int n = value.length;
                return n;
            }
        }

        private byte[] getValue(String name) throws IOException {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            if (this.values == null) {
                throw new FileSystemException(null, null, "attribute " + name + " not present");
            }
            byte[] value = this.values.get(name);
            if (value == null) {
                throw new FileSystemException(null, null, "attribute " + name + " not present");
            }
            return value;
        }

        @Override
        public int read(String name, ByteBuffer dst) throws IOException {
            try (AutoRelease lock = this.attributes.readLock();){
                byte[] value = this.getValue(name);
                int remaining = dst.remaining();
                int required = value.length;
                if (remaining < required) {
                    throw new FileSystemException(null, null, required + " bytes in buffer required but only " + remaining + " available");
                }
                int startPosition = dst.position();
                dst.put(value);
                int endPosition = dst.position();
                int n = endPosition - startPosition;
                return n;
            }
        }

        @Override
        public int write(String name, ByteBuffer src) {
            try (AutoRelease lock = this.attributes.writeLock();){
                if (name == null) {
                    throw new NullPointerException("name is null");
                }
                if (src == null) {
                    throw new NullPointerException("buffer is null");
                }
                int remaining = src.remaining();
                byte[] dst = new byte[remaining];
                int startPosition = src.position();
                src.get(dst);
                int endPosition = src.position();
                this.getValues().put(name, dst);
                int n = endPosition - startPosition;
                return n;
            }
        }

        @Override
        public void delete(String name) {
            try (AutoRelease lock = this.attributes.writeLock();){
                if (this.values != null) {
                    if (name == null) {
                        throw new NullPointerException("name is null");
                    }
                    this.values.remove(name);
                }
            }
        }
    }

    static class MemoryPosixFileAttributeView
    extends MemoryFileOwnerAttributeView
    implements PosixFileAttributeView,
    AccessCheck {
        private GroupPrincipal group;
        private int permissions;
        private final Path path;

        MemoryPosixFileAttributeView(MemoryEntryAttributes attributes, EntryCreationContext context) {
            super(attributes, context);
            if (context.group == null) {
                throw new NullPointerException("group");
            }
            this.group = context.group;
            this.permissions = MemoryEntryAttributes.toMask(context.permissions);
            this.path = context.path;
        }

        @Override
        public String name() {
            return "posix";
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            MemoryPosixFileAttributeView other = (MemoryPosixFileAttributeView)selfAttributes;
            this.group = other.group;
            this.permissions = other.permissions;
        }

        @Override
        public void setGroup(GroupPrincipal group) throws IOException {
            if (group == null) {
                throw new IllegalArgumentException("group must not be null");
            }
            try (AutoRelease lock = this.attributes.writeLock();){
                this.attributes.checkAccess(AccessMode.WRITE);
                this.group = group;
            }
        }

        @Override
        public PosixFileAttributes readAttributes() throws IOException {
            try (AutoRelease lock = this.attributes.readLock();){
                BasicFileAttributeView view = this.attributes.getFileAttributeView(BasicFileAttributeView.class);
                MemoryPosixFileAttributes memoryPosixFileAttributes = new MemoryPosixFileAttributes(view.readAttributes(), this.getOwner(), this.group, MemoryEntryAttributes.toSet(this.permissions));
                return memoryPosixFileAttributes;
            }
        }

        @Override
        public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
            if (perms == null) {
                throw new IllegalArgumentException("permissions must not be null");
            }
            try (AutoRelease lock = this.attributes.writeLock();){
                this.assertOwner();
                this.permissions = MemoryEntryAttributes.toMask(perms);
            }
        }

        @Override
        public void checkAccess(AccessMode mode) throws AccessDeniedException {
            GroupPrincipal group;
            UserPrincipal user = this.attributes.getCurrentUser();
            PosixFilePermission permission = user == this.getOwner() ? this.translateOwnerMode(mode) : ((group = this.attributes.getCurrentGroup()) == this.group ? this.translateGroupMode(mode) : this.translateOthersMode(mode));
            int flag = 1 << permission.ordinal() & this.permissions;
            if (flag == 0) {
                throw new AccessDeniedException(this.path.toString());
            }
        }

        void assertOwner() throws AccessDeniedException {
            UserPrincipal user = this.attributes.getCurrentUser();
            if (!this.getOwner().equals(user)) {
                throw new AccessDeniedException(this.path.toString());
            }
        }

        @Override
        public void checkAccess(AccessMode[] modes) throws AccessDeniedException {
            for (AccessMode mode : modes) {
                this.checkAccess(mode);
            }
        }

        private PosixFilePermission translateOwnerMode(AccessMode mode) {
            switch (mode) {
                case READ: {
                    return PosixFilePermission.OWNER_READ;
                }
                case WRITE: {
                    return PosixFilePermission.OWNER_WRITE;
                }
                case EXECUTE: {
                    return PosixFilePermission.OWNER_EXECUTE;
                }
            }
            throw new UnsupportedOperationException("access mode " + (Object)((Object)mode) + " is not supported");
        }

        private PosixFilePermission translateGroupMode(AccessMode mode) {
            switch (mode) {
                case READ: {
                    return PosixFilePermission.GROUP_READ;
                }
                case WRITE: {
                    return PosixFilePermission.GROUP_WRITE;
                }
                case EXECUTE: {
                    return PosixFilePermission.GROUP_EXECUTE;
                }
            }
            throw new UnsupportedOperationException("access mode " + (Object)((Object)mode) + " is not supported");
        }

        private PosixFilePermission translateOthersMode(AccessMode mode) {
            switch (mode) {
                case READ: {
                    return PosixFilePermission.OTHERS_READ;
                }
                case WRITE: {
                    return PosixFilePermission.OTHERS_WRITE;
                }
                case EXECUTE: {
                    return PosixFilePermission.OTHERS_EXECUTE;
                }
            }
            throw new UnsupportedOperationException("access mode " + (Object)((Object)mode) + " is not supported");
        }
    }

    static abstract class MemoryFileOwnerAttributeView
    extends DelegatingFileAttributesView
    implements FileOwnerAttributeView {
        private UserPrincipal owner;

        MemoryFileOwnerAttributeView(MemoryEntryAttributes attributes, EntryCreationContext context) {
            super(attributes);
            if (context.user == null) {
                throw new NullPointerException("owner");
            }
            this.owner = context.user;
        }

        @Override
        public UserPrincipal getOwner() {
            try (AutoRelease lock = this.attributes.readLock();){
                UserPrincipal userPrincipal = this.owner;
                return userPrincipal;
            }
        }

        @Override
        public void setOwner(UserPrincipal owner) throws IOException {
            if (owner == null) {
                throw new IllegalArgumentException("owner must not be null");
            }
            try (AutoRelease lock = this.attributes.writeLock();){
                this.attributes.checkAccess(AccessMode.WRITE);
                this.owner = owner;
            }
        }
    }

    static class MemoryDosFileAttributes
    extends DelegatingAttributes
    implements DosFileAttributes {
        private final boolean readOnly;
        private final boolean hidden;
        private final boolean system;
        private final boolean archive;

        MemoryDosFileAttributes(BasicFileAttributes delegate, boolean readOnly, boolean hidden, boolean system, boolean archive) {
            super(delegate);
            this.readOnly = readOnly;
            this.hidden = hidden;
            this.system = system;
            this.archive = archive;
        }

        @Override
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public boolean isArchive() {
            return this.archive;
        }

        @Override
        public boolean isSystem() {
            return this.system;
        }
    }

    static class MemoryPosixFileAttributes
    extends DelegatingAttributes
    implements PosixFileAttributes {
        private final UserPrincipal owner;
        private final GroupPrincipal group;
        private final Set<PosixFilePermission> permissions;

        MemoryPosixFileAttributes(BasicFileAttributes delegate, UserPrincipal owner, GroupPrincipal group, Set<PosixFilePermission> permissions) {
            super(delegate);
            this.owner = owner;
            this.group = group;
            this.permissions = permissions;
        }

        @Override
        public UserPrincipal owner() {
            return this.owner;
        }

        @Override
        public GroupPrincipal group() {
            return this.group;
        }

        @Override
        public Set<PosixFilePermission> permissions() {
            return this.permissions;
        }
    }

    static class DelegatingAttributes
    implements BasicFileAttributes {
        private final BasicFileAttributes delegate;

        DelegatingAttributes(BasicFileAttributes delegate) {
            this.delegate = delegate;
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.delegate.lastModifiedTime();
        }

        @Override
        public FileTime lastAccessTime() {
            return this.delegate.lastAccessTime();
        }

        @Override
        public FileTime creationTime() {
            return this.delegate.creationTime();
        }

        @Override
        public boolean isRegularFile() {
            return this.delegate.isRegularFile();
        }

        @Override
        public boolean isDirectory() {
            return this.delegate.isDirectory();
        }

        @Override
        public boolean isSymbolicLink() {
            return this.delegate.isSymbolicLink();
        }

        @Override
        public boolean isOther() {
            return this.delegate.isOther();
        }

        @Override
        public long size() {
            return this.delegate.size();
        }

        @Override
        public Object fileKey() {
            return this.delegate.fileKey();
        }
    }

    static class MemoryDosFileAttributeView
    extends DelegatingFileAttributesView
    implements DosFileAttributeView,
    AccessCheck {
        private boolean readOnly;
        private boolean hidden;
        private boolean system;
        private boolean archive;
        private final Path path;

        MemoryDosFileAttributeView(MemoryEntryAttributes attributes, EntryCreationContext context) {
            super(attributes);
            this.path = context.path;
        }

        @Override
        public String name() {
            return "dos";
        }

        @Override
        public void initializeRoot() {
            this.hidden = true;
            this.system = true;
        }

        @Override
        public DosFileAttributes readAttributes() throws IOException {
            try (AutoRelease lock = this.attributes.readLock();){
                BasicFileAttributeView view = this.attributes.getFileAttributeView(BasicFileAttributeView.class);
                MemoryDosFileAttributes memoryDosFileAttributes = new MemoryDosFileAttributes(view.readAttributes(), this.readOnly, this.hidden, this.system, this.archive);
                return memoryDosFileAttributes;
            }
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            MemoryDosFileAttributeView other = (MemoryDosFileAttributeView)selfAttributes;
            this.readOnly = other.readOnly;
            this.hidden = other.hidden;
            this.system = other.system;
            this.archive = other.archive;
        }

        @Override
        public void setReadOnly(boolean value) {
            try (AutoRelease lock = this.attributes.writeLock();){
                this.readOnly = value;
            }
        }

        @Override
        public void setHidden(boolean value) {
            try (AutoRelease lock = this.attributes.writeLock();){
                this.hidden = value;
            }
        }

        @Override
        public void setSystem(boolean value) {
            try (AutoRelease lock = this.attributes.writeLock();){
                this.system = value;
            }
        }

        @Override
        public void setArchive(boolean value) {
            try (AutoRelease lock = this.attributes.writeLock();){
                this.archive = value;
            }
        }

        @Override
        public void checkAccess(AccessMode mode) throws AccessDeniedException {
            switch (mode) {
                case READ: {
                    break;
                }
                case WRITE: {
                    if (!this.readOnly) break;
                    throw new AccessDeniedException(this.path.toString());
                }
                case EXECUTE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("access mode " + (Object)((Object)mode) + " is not supported");
                }
            }
        }

        @Override
        public void checkAccess(AccessMode[] modes) throws AccessDeniedException {
            for (AccessMode mode : modes) {
                this.checkAccess(mode);
            }
        }
    }

    static class MemoryAclFileAttributeView
    extends MemoryFileOwnerAttributeView
    implements AclFileAttributeView,
    AccessCheck {
        private List<AclEntry> acl = Collections.emptyList();
        private final Path path;

        MemoryAclFileAttributeView(MemoryEntryAttributes attributes, EntryCreationContext context) {
            super(attributes, context);
            this.path = context.path;
        }

        @Override
        public String name() {
            return "acl";
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            this.acl = new ArrayList<AclEntry>(((MemoryAclFileAttributeView)selfAttributes).acl);
        }

        @Override
        public void setAcl(List<AclEntry> acl) throws IOException {
            this.checkAccess(AclEntryPermission.WRITE_ACL);
            try (AutoRelease lock = this.attributes.writeLock();){
                this.acl = new ArrayList<AclEntry>(acl);
            }
        }

        @Override
        public List<AclEntry> getAcl() throws IOException {
            this.checkAccess(AclEntryPermission.READ_ACL);
            try (AutoRelease lock = this.attributes.readLock();){
                ArrayList<AclEntry> arrayList = new ArrayList<AclEntry>(this.acl);
                return arrayList;
            }
        }

        public void checkAccess(AclEntryPermission mode) throws AccessDeniedException {
            UserPrincipal currentUser = this.attributes.getCurrentUser();
            GroupPrincipal currentGroup = this.attributes.getCurrentGroup();
            for (AclEntry entry : this.acl) {
                UserPrincipal principal = entry.principal();
                if (!principal.equals(currentUser) && !principal.equals(currentGroup)) continue;
                Set<AclEntryPermission> permissions = entry.permissions();
                boolean applies = permissions.contains((Object)mode);
                AclEntryType type = entry.type();
                if (!applies) continue;
                if (type == AclEntryType.ALLOW) {
                    return;
                }
                if (type != AclEntryType.DENY) continue;
                throw new AccessDeniedException(this.path.toString());
            }
        }

        @Override
        public void checkAccess(AccessMode mode) throws AccessDeniedException {
            switch (mode) {
                case READ: {
                    this.checkAccess(AclEntryPermission.READ_DATA);
                    break;
                }
                case WRITE: {
                    this.checkAccess(AclEntryPermission.WRITE_DATA);
                    break;
                }
                case EXECUTE: {
                    this.checkAccess(AclEntryPermission.EXECUTE);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("access mode " + (Object)((Object)mode) + " is not supported");
                }
            }
        }

        @Override
        public void checkAccess(AccessMode[] modes) throws AccessDeniedException {
            for (AccessMode mode : modes) {
                this.checkAccess(mode);
            }
        }
    }

    static abstract class DelegatingFileAttributesView
    implements InitializingFileAttributeView {
        final MemoryEntryAttributes attributes;

        DelegatingFileAttributesView(MemoryEntryAttributes entry) {
            this.attributes = entry;
        }

        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            this.attributes.getBasicFileAttributeView().setTimes(lastModifiedTime, lastAccessTime, createTime);
        }

        @Override
        public void initializeFrom(BasicFileAttributeView basicFileAttributeView) {
        }

        @Override
        public void initializeRoot() {
        }

        @Override
        public void initializeFrom(Map<String, ? extends FileAttributeView> additionalAttributes) {
            FileAttributeView selfAttributes = additionalAttributes.get(this.name());
            if (selfAttributes != null) {
                this.initializeFromSelf(selfAttributes);
            }
        }

        abstract void initializeFromSelf(FileAttributeView var1);
    }

    static abstract class MemoryEntryFileAttributes
    implements BasicFileAttributes {
        private final FileTime lastModifiedTime;
        private final FileTime lastAccessTime;
        private final FileTime creationTime;
        private final Object fileKey;

        MemoryEntryFileAttributes(Object fileKey, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime) {
            this.fileKey = fileKey;
            this.lastModifiedTime = lastModifiedTime;
            this.lastAccessTime = lastAccessTime;
            this.creationTime = creationTime;
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public FileTime lastAccessTime() {
            return this.lastAccessTime;
        }

        @Override
        public FileTime creationTime() {
            return this.creationTime;
        }

        @Override
        public Object fileKey() {
            return this.fileKey;
        }
    }

    abstract class MemoryEntryFileAttributesView
    implements InitializingFileAttributeView,
    BasicFileAttributeView {
        MemoryEntryFileAttributesView() {
        }

        @Override
        public String name() {
            return "basic";
        }

        @Override
        public void initializeFrom(BasicFileAttributeView basicFileAttributeView) throws IOException {
            BasicFileAttributes otherAttributes = basicFileAttributeView.readAttributes();
            this.setTimes(otherAttributes.lastModifiedTime(), otherAttributes.lastAccessTime(), otherAttributes.creationTime());
        }

        @Override
        public void initializeFrom(Map<String, ? extends FileAttributeView> additionalAttributes) {
        }

        @Override
        public void initializeRoot() {
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            MemoryEntryAttributes.this.setTimes(lastModifiedTime, lastAccessTime, createTime);
        }
    }
}

