/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AppendingBlockChannel;
import com.github.marschall.memoryfilesystem.AppendingBlockOutputStream;
import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.BlockChannel;
import com.github.marschall.memoryfilesystem.BlockInputStream;
import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.MemoryContents;
import com.github.marschall.memoryfilesystem.MemoryEntry;
import com.github.marschall.memoryfilesystem.MemoryEntryAttributes;
import com.github.marschall.memoryfilesystem.MemoryFileLock;
import com.github.marschall.memoryfilesystem.MemoryInode;
import com.github.marschall.memoryfilesystem.NonAppendingBlockChannel;
import com.github.marschall.memoryfilesystem.NonAppendingBlockOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.util.Arrays;
import java.util.Set;

class MemoryFile
extends MemoryEntry
implements MemoryContents {
    private int openCount = 0;
    private final MemoryInode inode;

    MemoryFile(String originalName, EntryCreationContext context) {
        this(originalName, context, 0);
    }

    MemoryFile(String originalName, EntryCreationContext context, int initialBlocks) {
        super(originalName, context);
        this.inode = new MemoryInode(initialBlocks);
    }

    MemoryFile(String originalName, EntryCreationContext context, MemoryFile other) {
        super(originalName, context);
        this.inode = new MemoryInode(other.inode);
    }

    private MemoryFile(String originalName, EntryCreationContext context, MemoryInode inode, MemoryFile other) {
        super(originalName, context, other);
        this.inode = inode;
    }

    MemoryFile createLink(String originalName, EntryCreationContext context) {
        return new MemoryFile(originalName, context, this.inode, this);
    }

    @Override
    MemoryEntryAttributes newMemoryEntryAttributes(EntryCreationContext context) {
        return new MemoryFileAttributes(context);
    }

    @Override
    public void accessed() {
        super.accessed();
    }

    @Override
    public void modified() {
        super.modified();
    }

    @Override
    public long size() {
        return this.inode.size();
    }

    InputStream newInputStream(Set<? extends OpenOption> options, Path path) throws IOException {
        boolean deleteOnClose = options.contains(StandardOpenOption.DELETE_ON_CLOSE);
        boolean sync = options.contains(StandardOpenOption.SYNC);
        return this.newInputStream(deleteOnClose, path);
    }

    OutputStream newOutputStream(Set<? extends OpenOption> options, Path path) throws IOException {
        boolean deleteOnClose = options.contains(StandardOpenOption.DELETE_ON_CLOSE);
        boolean append = options.contains(StandardOpenOption.APPEND);
        boolean truncate = options.contains(StandardOpenOption.TRUNCATE_EXISTING);
        if (append && truncate) {
            throw new IllegalArgumentException("invalid combination of options: " + Arrays.asList(StandardOpenOption.APPEND, StandardOpenOption.TRUNCATE_EXISTING));
        }
        boolean sync = options.contains(StandardOpenOption.SYNC);
        if (append) {
            return this.newAppendingOutputStream(deleteOnClose, path);
        }
        if (truncate) {
            this.truncate(0L);
        }
        return this.newOutputStream(deleteOnClose, path);
    }

    BlockChannel newChannel(Set<? extends OpenOption> options, Path path) throws IOException {
        boolean append = options.contains(StandardOpenOption.APPEND);
        boolean writable = options.contains(StandardOpenOption.WRITE);
        boolean readable = options.contains(StandardOpenOption.READ) || !writable && !append;
        boolean deleteOnClose = options.contains(StandardOpenOption.DELETE_ON_CLOSE);
        boolean sync = options.contains(StandardOpenOption.SYNC);
        boolean truncate = options.contains(StandardOpenOption.TRUNCATE_EXISTING);
        if (writable && append && truncate) {
            throw new IllegalArgumentException("invalid combination of options: " + Arrays.asList(StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.TRUNCATE_EXISTING));
        }
        if (append) {
            return this.newAppendingChannel(readable, deleteOnClose, path);
        }
        if (writable && truncate) {
            this.truncate(0L);
        }
        return this.newChannel(readable, writable, deleteOnClose, path);
    }

    InputStream newInputStream(boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            BlockInputStream blockInputStream = new BlockInputStream(this, deleteOnClose, path);
            return blockInputStream;
        }
    }

    OutputStream newOutputStream(boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            NonAppendingBlockOutputStream nonAppendingBlockOutputStream = new NonAppendingBlockOutputStream(this, deleteOnClose, path);
            return nonAppendingBlockOutputStream;
        }
    }

    OutputStream newAppendingOutputStream(boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            AppendingBlockOutputStream appendingBlockOutputStream = new AppendingBlockOutputStream(this, deleteOnClose, path);
            return appendingBlockOutputStream;
        }
    }

    BlockChannel newChannel(boolean readable, boolean writable, boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            NonAppendingBlockChannel nonAppendingBlockChannel = new NonAppendingBlockChannel(this, readable, writable, deleteOnClose, path);
            return nonAppendingBlockChannel;
        }
    }

    BlockChannel newAppendingChannel(boolean readable, boolean deleteOnClose, Path path) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.incrementOpenCount(path);
            AppendingBlockChannel appendingBlockChannel = new AppendingBlockChannel(this, readable, this.size(), deleteOnClose, path);
            return appendingBlockChannel;
        }
    }

    private void incrementOpenCount(Path path) throws NoSuchFileException {
        if (this.openCount < 0) {
            throw new NoSuchFileException(path.toString());
        }
        ++this.openCount;
    }

    int openCount() {
        return this.openCount;
    }

    void markForDeletion() {
        this.openCount = -1;
    }

    @Override
    public void closedStream(Path path, boolean delete) {
        try (AutoRelease lock = this.writeLock();){
            --this.openCount;
        }
        if (delete) {
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void closedChannel(Path path, boolean delete) {
        try (AutoRelease lock = this.writeLock();){
            --this.openCount;
        }
        if (delete) {
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public long read(ByteBuffer dst, long position, long maximum) throws IOException {
        return this.inode.read(dst, position, maximum);
    }

    @Override
    public int readShort(ByteBuffer dst, long position) throws IOException {
        return this.inode.readShort(dst, position);
    }

    @Override
    public int read(byte[] dst, long position, int off, int len) throws IOException {
        return this.inode.read(dst, position, off, len);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        return this.inode.transferFrom(src, position, count);
    }

    @Override
    public long transferTo(WritableByteChannel target, long position, long count) throws IOException {
        return this.inode.transferTo(target, position, count);
    }

    @Override
    public long transferTo(OutputStream target, long position) throws IOException {
        return this.inode.transferTo(target, position);
    }

    @Override
    public long write(ByteBuffer src, long position, long maximum) {
        return this.inode.write(src, position, maximum);
    }

    @Override
    public int writeShort(ByteBuffer src, long position) {
        return this.inode.writeShort(src, position);
    }

    @Override
    public int write(byte[] src, long position, int off, int len) {
        return this.inode.write(src, position, off, len);
    }

    @Override
    public long writeAtEnd(ByteBuffer src, long maximum) {
        return this.inode.writeAtEnd(src, maximum);
    }

    @Override
    public int writeAtEnd(ByteBuffer src) {
        return this.inode.writeAtEnd(src);
    }

    @Override
    public int writeAtEnd(byte[] src, int off, int len) {
        return this.inode.writeAtEnd(src, off, len);
    }

    @Override
    public void truncate(long newSize) {
        this.inode.truncate(newSize);
    }

    @Override
    public MemoryFileLock tryLock(MemoryFileLock lock) {
        return this.inode.tryLock(lock);
    }

    @Override
    public MemoryFileLock lock(MemoryFileLock lock) throws IOException {
        return this.inode.lock(lock);
    }

    @Override
    public void unlock(MemoryFileLock lock) {
        this.inode.unlock(lock);
    }

    public String toString() {
        return "file(" + this.getOriginalName() + ')';
    }

    boolean hasSameInodeAs(MemoryFile other) {
        return this.inode == other.inode;
    }

    final class MemoryFileAttributes
    extends MemoryEntryAttributes {
        MemoryFileAttributes(EntryCreationContext context) {
            super(context);
        }

        @Override
        BasicFileAttributeView newBasicFileAttributeView() {
            return new MemoryEntryAttributes.MemoryFileAttributesView(this);
        }

        @Override
        long size() {
            return MemoryFile.this.size();
        }
    }
}

