/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.AutoReleaseLock;
import com.github.marschall.memoryfilesystem.MemoryFileSystemWatchService;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class MemoryWatchKey
implements WatchKey {
    private final AbstractPath path;
    private final Lock lock;
    private boolean isOverflow;
    private State state;
    private boolean valid;
    private final Set<WatchEvent.Kind<?>> events;
    private List<WatchEvent<?>> accumulatedEvents;
    private Map<AbstractPath, Integer> accumulatedModificationEvents;
    private List<WatchEvent<?>> pendingEvents;
    private final MemoryFileSystemWatchService watcher;

    MemoryWatchKey(AbstractPath path, MemoryFileSystemWatchService watcher, Set<WatchEvent.Kind<?>> events) {
        this.path = path;
        this.watcher = watcher;
        this.events = events;
        this.state = State.READY;
        this.lock = new ReentrantLock();
    }

    boolean accepts(WatchEvent.Kind<?> event) {
        return this.events.contains(event);
    }

    @Override
    public List<WatchEvent<?>> pollEvents() {
        try (AutoRelease autoRelease = AutoReleaseLock.autoRelease(this.lock);){
            if (this.state != State.SIGNALLED) {
                // empty if block
            }
            if (this.pendingEvents == null) {
                List<WatchEvent<?>> list = Collections.emptyList();
                return list;
            }
            List<WatchEvent<?>> result = this.pendingEvents;
            this.pendingEvents = null;
            List<WatchEvent<?>> list = result;
            return list;
        }
    }

    @Override
    public boolean reset() {
        try (AutoRelease autoRelease = AutoReleaseLock.autoRelease(this.lock);){
            if (!this.valid) {
                boolean bl = false;
                return bl;
            }
            if (this.pendingEvents != null) {
                this.state = State.READY;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void cancel() {
        try (AutoRelease autoRelease = AutoReleaseLock.autoRelease(this.lock);){
            this.valid = false;
        }
    }

    @Override
    public boolean isValid() {
        try (AutoRelease autoRelease = AutoReleaseLock.autoRelease(this.lock);){
            boolean bl = this.valid;
            return bl;
        }
    }

    @Override
    public AbstractPath watchable() {
        return this.path;
    }

    static enum State {
        READY,
        SIGNALLED;

    }
}

