/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.InitializingFileAttributeView;
import com.github.marschall.memoryfilesystem.MemoryEntry;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

class MemorySymbolicLink
extends MemoryEntry {
    private final AbstractPath target;
    private final MemorySymbolicLinkAttributesView basicFileAttributeView;

    MemorySymbolicLink(String originalName, AbstractPath target) {
        this(originalName, target, EntryCreationContext.empty());
    }

    MemorySymbolicLink(String originalName, AbstractPath target, EntryCreationContext context) {
        super(originalName, context);
        this.target = target;
        this.basicFileAttributeView = new MemorySymbolicLinkAttributesView();
    }

    AbstractPath getTarget() {
        return this.target;
    }

    @Override
    BasicFileAttributeView getBasicFileAttributeView() {
        return this.basicFileAttributeView;
    }

    @Override
    InitializingFileAttributeView getInitializingFileAttributeView() {
        return this.basicFileAttributeView;
    }

    public String toString() {
        return "symlink(" + this.getOriginalName() + ") -> " + this.target;
    }

    static final class MemorySymbolicLinkAttributes
    extends MemoryEntry.MemoryEntryFileAttributes {
        MemorySymbolicLinkAttributes(Object fileKey, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime) {
            super(fileKey, lastModifiedTime, lastAccessTime, creationTime);
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return true;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }
    }

    class MemorySymbolicLinkAttributesView
    extends MemoryEntry.MemoryEntryFileAttributesView {
        MemorySymbolicLinkAttributesView() {
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            MemorySymbolicLink.this.checkAccess(AccessMode.READ);
            try (AutoRelease lock = MemorySymbolicLink.this.readLock();){
                FileTime lastModifiedTime = MemorySymbolicLink.this.lastModifiedTime();
                FileTime lastAccessTime = MemorySymbolicLink.this.lastAccessTime();
                FileTime creationTime = MemorySymbolicLink.this.creationTime();
                MemorySymbolicLinkAttributes memorySymbolicLinkAttributes = new MemorySymbolicLinkAttributes(MemorySymbolicLink.this, lastModifiedTime, lastAccessTime, creationTime);
                return memorySymbolicLinkAttributes;
            }
        }
    }
}

