/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.ClosedStreamChecker;
import com.github.marschall.memoryfilesystem.MemoryContents;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;

final class BlockInputStream
extends InputStream {
    private static final int MAX_SKIP_SIZE = 2048;
    private final MemoryContents memoryContents;
    private final ClosedStreamChecker checker;
    private final AtomicLong position;
    private Path pathToDelete;

    BlockInputStream(MemoryContents memoryContents, boolean deleteOnClose, Path path) {
        this.memoryContents = memoryContents;
        this.checker = new ClosedStreamChecker();
        this.position = new AtomicLong(0L);
        this.pathToDelete = deleteOnClose ? path : null;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checker.check();
        boolean success = false;
        int read = 0;
        while (!success) {
            long positionBefore = this.position.get();
            read = this.memoryContents.read(b, positionBefore, off, len);
            if (read == -1) {
                return read;
            }
            success = this.position.compareAndSet(positionBefore, positionBefore + (long)read);
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checker.check();
        long positionBefore = this.position.get();
        long fileSize = this.memoryContents.size();
        long skipped = Math.min(Math.min(n, fileSize - positionBefore), 2048L);
        this.position.compareAndSet(positionBefore, positionBefore + skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        this.checker.check();
        long available = this.memoryContents.size() - this.position.get();
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (available > 1L) {
            return (int)(available - 1L);
        }
        return (int)available;
    }

    @Override
    public void close() throws IOException {
        this.checker.close();
        this.memoryContents.accessed();
        this.memoryContents.closedStream(this.pathToDelete);
    }

    @Override
    public int read() throws IOException {
        byte[] data = new byte[1];
        int read = this.read(data);
        if (read == -1) {
            return read;
        }
        return data[0];
    }
}

