/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.BlockChannel;
import com.github.marschall.memoryfilesystem.MemoryContents;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;

final class NonAppendingBlockChannel
extends BlockChannel {
    private final boolean writable;

    NonAppendingBlockChannel(MemoryContents memoryContents, boolean readable, boolean writable, boolean deleteOnClose, Path path) {
        super(memoryContents, readable, deleteOnClose, path);
        this.writable = writable;
    }

    @Override
    void writeCheck() throws ClosedChannelException {
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        this.closedCheck();
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            int n = this.memoryContents.writeShort(src, position);
            return n;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            int written = this.memoryContents.writeShort(src, this.position);
            this.position += (long)written;
            int n = written;
            return n;
        }
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.validatePositionAndCount(position, count);
        try (AutoRelease lock = this.writeLock();){
            long l = this.memoryContents.transferFrom(src, position, count);
            return l;
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.validateOffsetAndLength(srcs, offset, length);
        try (AutoRelease lock = this.writeLock();){
            long written;
            long totalWritten = 0L;
            for (int i = 0; i < length && totalWritten != Long.MAX_VALUE; totalWritten += written, ++i) {
                written = this.memoryContents.write(srcs[offset + i], this.position, Long.MAX_VALUE - totalWritten);
                if (written != -1L) {
                    this.position += written;
                    continue;
                }
                if (i != 0) break;
                long l = -1L;
                return l;
            }
            long l = totalWritten;
            return l;
        }
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.memoryContents.truncate(size);
            this.position = this.memoryContents.size();
        }
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        if (metaData) {
            if (!this.writable) {
                this.memoryContents.accessed();
            } else {
                this.memoryContents.modified();
            }
        }
    }
}

