/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.AutoReleaseLock;
import com.github.marschall.memoryfilesystem.MemoryContents;
import com.github.marschall.memoryfilesystem.MemoryFileLock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class BlockChannel
extends FileChannel {
    volatile long position;
    final MemoryContents memoryContents;
    final boolean readable;
    private final Lock lock;
    private Set<MemoryFileLock> fileLocks;
    private final Path pathToDelete;

    BlockChannel(MemoryContents memoryContents, boolean readable, boolean deleteOnClose, Path path) {
        this.memoryContents = memoryContents;
        this.readable = readable;
        this.lock = new ReentrantLock();
        this.pathToDelete = deleteOnClose ? path : null;
    }

    void closedCheck() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    abstract void writeCheck() throws ClosedChannelException;

    private void readCheck() throws ClosedChannelException {
        this.closedCheck();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
    }

    AutoRelease writeLock() throws ClosedChannelException {
        this.writeCheck();
        return AutoReleaseLock.autoRelease(this.lock);
    }

    private AutoRelease readLock() throws ClosedChannelException {
        this.readCheck();
        return AutoReleaseLock.autoRelease(this.lock);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        try (AutoRelease lock = this.readLock();){
            int read = this.memoryContents.readShort(dst, this.position);
            if (read != -1) {
                this.position += (long)read;
            }
            int n = read;
            return n;
        }
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.validateOffsetAndLength(dsts, offset, length);
        try (AutoRelease lock = this.readLock();){
            long read;
            long totalRead = 0L;
            for (int i = 0; i < length && totalRead != Long.MAX_VALUE; totalRead += read, ++i) {
                read = this.memoryContents.read(dsts[offset + i], this.position, Long.MAX_VALUE - totalRead);
                if (read != -1L) {
                    this.position += read;
                    continue;
                }
                if (i != 0) break;
                long l = -1L;
                return l;
            }
            long l = totalRead;
            return l;
        }
    }

    void validatePositionAndCount(long position, long count) {
        if (position < 0L) {
            throw new IllegalArgumentException("position must be positive");
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count must be positive");
        }
    }

    void validateOffsetAndLength(ByteBuffer[] buffers, int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset must not be negative");
        }
        if (offset >= buffers.length) {
            throw new IndexOutOfBoundsException("offset must be smaller than " + buffers.length);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must not be negative");
        }
        if (length > buffers.length - offset) {
            throw new IndexOutOfBoundsException("length too large");
        }
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        try (AutoRelease lock = this.readLock();){
            int n = this.memoryContents.readShort(dst, position);
            return n;
        }
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        this.validatePositionAndCount(position, count);
        try (AutoRelease lock = this.readLock();){
            long l = this.memoryContents.transferTo(target, position, count);
            return l;
        }
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException("memory file system does not support mmapped IO");
    }

    @Override
    public long position() throws IOException {
        this.closedCheck();
        return this.position;
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("only a non-negative values are allowed, " + newPosition + " is invalid");
        }
        this.closedCheck();
        try (AutoRelease autoRelease = AutoReleaseLock.autoRelease(this.lock);){
            this.position = newPosition;
        }
        return this;
    }

    @Override
    public long size() throws IOException {
        this.closedCheck();
        return this.memoryContents.size();
    }

    MemoryFileLock lock(MemoryFileLock l) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            MemoryFileLock fileLock = this.memoryContents.lock(l);
            this.addLock(fileLock);
            MemoryFileLock memoryFileLock = fileLock;
            return memoryFileLock;
        }
    }

    FileLock tryLock(MemoryFileLock l) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            MemoryFileLock fileLock = this.memoryContents.tryLock(l);
            if (fileLock != null) {
                this.addLock(fileLock);
            }
            MemoryFileLock memoryFileLock = fileLock;
            return memoryFileLock;
        }
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.lock(new MemoryFileLock(this, position, size, shared));
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.tryLock(new MemoryFileLock(this, position, size, shared));
    }

    private void addLock(MemoryFileLock fileLock) {
        if (this.fileLocks == null) {
            this.fileLocks = new HashSet<MemoryFileLock>();
        }
        this.fileLocks.add(fileLock);
    }

    void removeLock(MemoryFileLock fileLock) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.fileLocks.remove(fileLock);
            this.memoryContents.unlock(fileLock);
        }
    }

    @Override
    protected void implCloseChannel() throws IOException {
        try (AutoRelease lock = AutoReleaseLock.autoRelease(this.lock);){
            this.force(true);
            if (this.fileLocks != null) {
                for (MemoryFileLock fileLock : this.fileLocks) {
                    this.memoryContents.unlock(fileLock);
                }
            }
            this.memoryContents.closedChannel(this.pathToDelete);
        }
    }
}

