/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.ClosedWatchServiceChecker;
import com.github.marschall.memoryfilesystem.MemoryWatchKey;
import java.io.IOException;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

final class MemoryFileSystemWatchService
implements WatchService {
    private final ClosedWatchServiceChecker checker = new ClosedWatchServiceChecker();
    private final BlockingQueue<MemoryWatchKey> readyKeys = new LinkedBlockingQueue<MemoryWatchKey>();

    MemoryFileSystemWatchService() {
    }

    @Override
    public void close() throws IOException {
        this.checker.close();
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey poll() {
        this.checker.check();
        return (WatchKey)this.readyKeys.poll();
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.checker.check();
        return this.readyKeys.poll(timeout, unit);
    }

    @Override
    public WatchKey take() throws InterruptedException {
        this.checker.check();
        return this.readyKeys.take();
    }
}

