/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.portlet.server.request;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.WindowState;
import org.springframework.mock.web.portlet.MockPortletRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockPortletRequestBuilder {
    private final MultiValueMap<String, String> parameters = new LinkedMultiValueMap();
    private final MultiValueMap<String, String> preferences = new LinkedMultiValueMap();
    private final Map<String, Object> sessionPortletAttributes = new HashMap<String, Object>();
    private final Map<String, Object> sessionApplicationAttributes = new HashMap<String, Object>();
    private PortletMode portletMode = PortletMode.VIEW;
    private WindowState windowState = WindowState.NORMAL;

    protected void addParameter(String name, String ... values) {
        MockPortletRequestBuilder.addToMultiValueMap(this.parameters, name, values);
    }

    protected void addPreference(String name, String ... values) {
        MockPortletRequestBuilder.addToMultiValueMap(this.preferences, name, values);
    }

    protected void setPortletMode(PortletMode portletMode) {
        Assert.notNull((Object)portletMode, (String)"'portletMode' is required");
        this.portletMode = portletMode;
    }

    protected void setWindowState(WindowState windowState) {
        Assert.notNull((Object)windowState, (String)"'windowState' is required");
        this.windowState = windowState;
    }

    protected void addSessionPortletAttributes(Map<String, Object> sessionPortletAttributes) {
        this.sessionPortletAttributes.putAll(sessionPortletAttributes);
    }

    protected void addSessionApplicationAttributes(Map<String, Object> sessionApplicationAttributes) {
        this.sessionApplicationAttributes.putAll(sessionApplicationAttributes);
    }

    protected void setAll(MockPortletRequest request) {
        this.setParameters(request);
        this.setPreferences(request);
        request.setPortletMode(this.portletMode);
        request.setWindowState(this.windowState);
        if (!this.sessionPortletAttributes.isEmpty() || !this.sessionApplicationAttributes.isEmpty()) {
            PortletSession session = request.getPortletSession();
            this.addAttributes(session, this.sessionPortletAttributes, 2);
            this.addAttributes(session, this.sessionApplicationAttributes, 1);
        }
    }

    private void addAttributes(PortletSession session, Map<String, Object> attributes, int scope) {
        for (String attributeName : attributes.keySet()) {
            session.setAttribute(attributeName, attributes.get(attributeName), scope);
        }
    }

    private void setPreferences(MockPortletRequest request) {
        PortletPreferences preferences = request.getPreferences();
        try {
            for (String name : this.preferences.keySet()) {
                List values = (List)this.preferences.get((Object)name);
                preferences.setValues(name, values.toArray(new String[0]));
            }
        }
        catch (ReadOnlyException e) {
            throw new IllegalArgumentException("Read only preferences object is not supported", e);
        }
    }

    private void setParameters(MockPortletRequest request) {
        for (String name : this.parameters.keySet()) {
            List params = (List)this.parameters.get((Object)name);
            request.addParameter(name, params.toArray(new String[0]));
        }
    }

    private static <T> void addToMultiValueMap(MultiValueMap<String, T> map, String name, T[] values) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull(values, (String)"'values' is required");
        Assert.notEmpty((Object[])values, (String)"'values' must not be empty");
        for (T value : values) {
            map.add((Object)name, value);
        }
    }
}

