/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.portlet.server;

import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.test.web.portlet.server.DefaultPortletMvcResult;
import org.springframework.test.web.portlet.server.PortletMockMvc;
import org.springframework.web.portlet.DispatcherPortlet;
import org.springframework.web.portlet.HandlerExecutionChain;
import org.springframework.web.portlet.ModelAndView;

public class TestDispatcherPortlet
extends DispatcherPortlet {
    private ApplicationContext context;

    public TestDispatcherPortlet(ApplicationContext context) {
        this.context = context;
    }

    protected ApplicationContext createPortletApplicationContext(ApplicationContext parent) {
        return this.context;
    }

    protected DefaultPortletMvcResult getMvcResult(PortletRequest request) {
        return (DefaultPortletMvcResult)request.getAttribute(PortletMockMvc.MVC_RESULT_ATTRIBUTE);
    }

    protected void render(ModelAndView mv, PortletRequest request, MimeResponse response) throws Exception {
        DefaultPortletMvcResult mvcResult = this.getMvcResult(request);
        mvcResult.setModelAndView(mv);
        super.render(mv, request, response);
    }

    protected HandlerExecutionChain getHandler(PortletRequest request) throws Exception {
        HandlerExecutionChain chain = super.getHandler(request);
        if (chain != null) {
            DefaultPortletMvcResult mvcResult = this.getMvcResult(request);
            mvcResult.setHandler(chain.getHandler());
            mvcResult.setInterceptors(chain.getInterceptors());
        }
        return chain;
    }

    protected ModelAndView processHandlerException(RenderRequest request, RenderResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView mav = super.processHandlerException(request, response, handler, ex);
        this.processHandlerException((PortletRequest)request, mav, ex);
        return mav;
    }

    protected ModelAndView processHandlerException(ResourceRequest request, ResourceResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView mav = super.processHandlerException(request, response, handler, ex);
        this.processHandlerException((PortletRequest)request, mav, ex);
        return mav;
    }

    private void processHandlerException(PortletRequest request, ModelAndView mav, Exception e) {
        DefaultPortletMvcResult mvcResult = this.getMvcResult(request);
        mvcResult.setResolvedException(e);
        mvcResult.setModelAndView(mav);
    }
}

