/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.portlet.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.test.web.portlet.server.DefaultPortletMockMvcBuilder;
import org.springframework.test.web.portlet.server.PortletMockMvc;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.mvc.annotation.AnnotationMethodHandlerAdapter;
import org.springframework.web.portlet.mvc.annotation.DefaultAnnotationHandlerMapping;

public class StandalonePortletMockMvcBuilder
extends DefaultPortletMockMvcBuilder {
    private Object[] controllers;
    private Validator validator;
    private List<HandlerInterceptor> interceptors = new ArrayList<HandlerInterceptor>();

    public StandalonePortletMockMvcBuilder(Object ... controllers) {
        Assert.isTrue((!ObjectUtils.isEmpty((Object[])controllers) ? 1 : 0) != 0, (String)"At least one controller is required");
        this.controllers = controllers;
    }

    public StandalonePortletMockMvcBuilder setValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public StandalonePortletMockMvcBuilder addInteceptors(HandlerInterceptor ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    protected ApplicationContext initApplicationContext() {
        GenericWebApplicationContext wac = new GenericWebApplicationContext();
        this.addControllers(wac);
        this.addHandlerInterceptors(wac);
        RootBeanDefinition mappingDef = new RootBeanDefinition(DefaultAnnotationHandlerMapping.class);
        mappingDef.getPropertyValues().add("interceptors", this.interceptors);
        wac.registerBeanDefinition("handlerMapping", (BeanDefinition)mappingDef);
        RootBeanDefinition adapterDef = new RootBeanDefinition(AnnotationMethodHandlerAdapter.class);
        if (this.validator != null) {
            ConfigurableWebBindingInitializer webBindingInitializer = new ConfigurableWebBindingInitializer();
            webBindingInitializer.setValidator(this.validator);
            adapterDef.getPropertyValues().add("webBindingInitializer", (Object)webBindingInitializer);
        }
        wac.registerBeanDefinition("handlerAdapter", (BeanDefinition)adapterDef);
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)wac);
        wac.refresh();
        return wac;
    }

    private void addHandlerInterceptors(GenericWebApplicationContext wac) {
        for (int i = 0; i < this.interceptors.size(); ++i) {
            wac.getBeanFactory().registerSingleton("interceptor" + i, (Object)this.interceptors.get(i));
        }
    }

    private void addControllers(GenericWebApplicationContext wac) {
        for (int i = 0; i < this.controllers.length; ++i) {
            wac.getBeanFactory().registerSingleton("controller" + i, this.controllers[i]);
        }
    }

    public PortletMockMvc build() {
        this.setApplicationContext(this.initApplicationContext());
        return super.build();
    }
}

