/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web;

public abstract class AssertionErrors {
    private AssertionErrors() {
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void fail(String message, Object expected, Object actual) {
        throw new AssertionError((Object)(message + " expected:<" + expected + "> but was:<" + actual + ">"));
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            AssertionErrors.fail(message);
        }
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        AssertionErrors.fail(message, expected, actual);
    }
}

