/*
 * Decompiled with CFR 0.152.
 */
package com.paginate.abslistview;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.WrapperListAdapter;
import com.paginate.abslistview.LoadingListItemCreator;

class WrapperAdapter
extends BaseAdapter
implements WrapperListAdapter {
    private final BaseAdapter wrappedAdapter;
    private final LoadingListItemCreator loadingListItemCreator;
    private boolean displayLoadingRow = true;

    public WrapperAdapter(BaseAdapter wrappedAdapter, LoadingListItemCreator loadingListItemCreator) {
        this.wrappedAdapter = wrappedAdapter;
        this.loadingListItemCreator = loadingListItemCreator;
    }

    public ListAdapter getWrappedAdapter() {
        return this.wrappedAdapter;
    }

    public int getCount() {
        return this.displayLoadingRow ? this.wrappedAdapter.getCount() + 1 : this.wrappedAdapter.getCount();
    }

    public Object getItem(int position) {
        return this.isLoadingRow(position) ? null : this.wrappedAdapter.getItem(position);
    }

    public long getItemId(int position) {
        return this.isLoadingRow(position) ? -1L : this.wrappedAdapter.getItemId(position);
    }

    public int getViewTypeCount() {
        return this.displayLoadingRow ? this.wrappedAdapter.getViewTypeCount() + 1 : this.wrappedAdapter.getViewTypeCount();
    }

    public int getItemViewType(int position) {
        return this.isLoadingRow(position) ? this.getViewTypeCount() - 1 : this.wrappedAdapter.getItemViewType(position);
    }

    public boolean isEnabled(int position) {
        return !this.isLoadingRow(position) && this.wrappedAdapter.isEnabled(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (this.isLoadingRow(position)) {
            if (convertView == null) {
                convertView = this.loadingListItemCreator.newView(position, parent);
            }
            this.loadingListItemCreator.bindView(position, convertView);
            return convertView;
        }
        return this.wrappedAdapter.getView(position, convertView, parent);
    }

    void displayLoadingRow(boolean displayLoadingRow) {
        if (this.displayLoadingRow != displayLoadingRow) {
            this.displayLoadingRow = displayLoadingRow;
            this.notifyDataSetChanged();
        }
    }

    boolean isLoadingRow(int position) {
        return this.displayLoadingRow && position == this.getLoadingRowPosition();
    }

    private int getLoadingRowPosition() {
        return this.displayLoadingRow ? this.getCount() - 1 : -1;
    }
}

