/*
 * Decompiled with CFR 0.152.
 */
package com.marcoscg.ratedialog;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.support.v7.app.AlertDialog;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.marcoscg.ratedialog.R;

public class RateDialog {
    public static int DEFAULT_DAYS_UNTIL_PROMPT = 3;
    public static int DEFAULT_LAUNCHES_UNTIL_PROMPT = 7;
    private static String DEFAULT_DIALOG_KEY = "ratedialog";
    private Activity activity;
    private SharedPreferences prefs;
    private String dialogKey;
    private int daysUntilPrompt;
    private int launchesUntilPrompt;

    public RateDialog(Activity activity, String dialogKey) {
        this(activity, dialogKey, DEFAULT_DAYS_UNTIL_PROMPT, DEFAULT_LAUNCHES_UNTIL_PROMPT);
    }

    public RateDialog(Activity activity) {
        this(activity, DEFAULT_DIALOG_KEY);
    }

    public RateDialog(Activity activity, String dialogKey, int daysUntilPrompt, int launchesUntilPrompt) {
        this.activity = activity;
        this.dialogKey = dialogKey;
        this.daysUntilPrompt = daysUntilPrompt;
        this.launchesUntilPrompt = launchesUntilPrompt;
        this.prefs = activity.getSharedPreferences(dialogKey, 0);
    }

    public RateDialog(Activity activity, int daysUntilPrompt, int launchesUntilPrompt) {
        this(activity, DEFAULT_DIALOG_KEY, daysUntilPrompt, launchesUntilPrompt);
    }

    @Deprecated
    public static void with(Activity activity) {
        RateDialog.init(activity);
    }

    @Deprecated
    public static void with(Activity activity, int daysUntilPrompt, int launchesUntilPrompt) {
        RateDialog.init(activity, daysUntilPrompt, launchesUntilPrompt);
    }

    public static void init(Activity activity) {
        RateDialog.init(activity, DEFAULT_DAYS_UNTIL_PROMPT, DEFAULT_LAUNCHES_UNTIL_PROMPT);
    }

    public static void init(Activity activity, int daysUntilPrompt, int launchesUntilPrompt) {
        new RateDialog(activity, DEFAULT_DIALOG_KEY, daysUntilPrompt, launchesUntilPrompt).init();
    }

    @Deprecated
    public static void show(Activity activity) {
        RateDialog.showDialog(activity);
    }

    public static void showDialog(Activity activity) {
        new RateDialog(activity, DEFAULT_DIALOG_KEY).showDialog();
    }

    public void init() {
        if (this.prefs == null || this.prefs.getBoolean(this.dialogKey + "dontshowagain", false)) {
            return;
        }
        long launch_count = this.prefs.getLong(this.dialogKey + "launch_count", 0L) + 1L;
        this.prefs.edit().putLong(this.dialogKey + "launch_count", launch_count).apply();
        long date_firstLaunch = this.prefs.getLong(this.dialogKey + "date_firstlaunch", 0L);
        if (date_firstLaunch == 0L) {
            date_firstLaunch = System.currentTimeMillis();
            this.prefs.edit().putLong(this.dialogKey + "date_firstlaunch", date_firstLaunch).apply();
        }
        if (launch_count >= (long)this.launchesUntilPrompt && System.currentTimeMillis() >= date_firstLaunch + (long)(this.daysUntilPrompt * 24 * 60 * 60 * 1000)) {
            RateDialog.show(this.activity);
        }
    }

    public void showDialog() {
        LayoutInflater inflater = this.activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.dialog_layout, null);
        TextView title = (TextView)view.findViewById(R.id.title);
        TextView message = (TextView)view.findViewById(R.id.message);
        title.setText((CharSequence)String.format(this.activity.getResources().getString(R.string.rate_dialog_title), this.activity.getResources().getString(R.string.app_name)));
        message.setText((CharSequence)this.activity.getString(R.string.rate_dialog_message, new Object[]{this.activity.getResources().getString(R.string.app_name)}));
        AlertDialog dialog = new AlertDialog.Builder((Context)this.activity).setView(view).setPositiveButton((CharSequence)this.activity.getResources().getString(R.string.rate_dialog_action_rate), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                try {
                    RateDialog.this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + RateDialog.this.activity.getPackageName()))));
                }
                catch (ActivityNotFoundException anfe) {
                    RateDialog.this.activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + RateDialog.this.activity.getPackageName()))));
                }
                RateDialog.this.neverShow();
                Toast.makeText((Context)RateDialog.this.activity, (CharSequence)RateDialog.this.activity.getResources().getString(R.string.rate_dialog_thank_you), (int)0).show();
            }
        }).setNeutralButton((CharSequence)this.activity.getResources().getString(R.string.rate_dialog_action_later), null).setNegativeButton((CharSequence)this.activity.getResources().getString(R.string.rate_dialog_action_never), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RateDialog.this.neverShow();
            }
        }).show();
        Typeface tf = Typeface.createFromAsset((AssetManager)this.activity.getAssets(), (String)"medium.ttf");
        Button positivebt = dialog.getButton(-1);
        Button neutralbt = dialog.getButton(-3);
        Button negativebt = dialog.getButton(-2);
        positivebt.setPadding(RateDialog.dpToPx(12, this.activity), 0, RateDialog.dpToPx(12, this.activity), 0);
        positivebt.setTypeface(tf);
        neutralbt.setPadding(RateDialog.dpToPx(12, this.activity), 0, RateDialog.dpToPx(12, this.activity), 0);
        neutralbt.setTypeface(tf);
        negativebt.setPadding(RateDialog.dpToPx(12, this.activity), 0, RateDialog.dpToPx(12, this.activity), 0);
        negativebt.setTypeface(tf);
    }

    private void neverShow() {
        if (this.prefs != null) {
            this.prefs.edit().putBoolean(this.dialogKey + "dontshowagain", true).apply();
        }
    }

    private static int dpToPx(int dp, Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            dp += 2;
        }
        DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();
        return Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
    }
}

