/*
 * Decompiled with CFR 0.152.
 */
package com.marcoscg.fingerauth;

import android.app.KeyguardManager;
import android.content.Context;
import android.os.Build;
import android.support.v4.hardware.fingerprint.FingerprintManagerCompat;
import android.support.v4.os.CancellationSignal;

public class FingerAuth {
    private OnFingerAuthListener onFingerAuthListener;
    private FingerprintManagerCompat fingerprintManagerCompat;
    private CancellationSignal cancellationSignal;
    private FingerprintManagerCompat.AuthenticationCallback authenticationCallback;
    private int failedCount = 0;
    private int maxFailedCount = 3;

    public FingerAuth(Context context) {
        this.init(context);
    }

    public FingerAuth setOnFingerAuthListener(OnFingerAuthListener onFingerAuthListener) {
        this.onFingerAuthListener = onFingerAuthListener;
        return this;
    }

    public FingerAuth setMaxFailedCount(int maxFailedCount) {
        this.maxFailedCount = maxFailedCount;
        return this;
    }

    private void init(Context context) {
        this.failedCount = 0;
        this.authenticationCallback = new FingerprintManagerCompat.AuthenticationCallback(){

            public void onAuthenticationFailed() {
                FingerAuth.this.failedCount++;
                if (FingerAuth.this.failedCount == FingerAuth.this.maxFailedCount) {
                    FingerAuth.this.failedCount = 0;
                    if (FingerAuth.this.onFingerAuthListener != null) {
                        FingerAuth.this.cancelSignal();
                        FingerAuth.this.onFingerAuthListener.onError();
                    }
                } else {
                    FingerAuth.this.onFingerAuthListener.onFailure();
                }
            }

            public void onAuthenticationSucceeded(FingerprintManagerCompat.AuthenticationResult result) {
                if (FingerAuth.this.onFingerAuthListener != null) {
                    FingerAuth.this.cancelSignal();
                    FingerAuth.this.onFingerAuthListener.onSuccess();
                }
            }
        };
        this.fingerprintManagerCompat = FingerprintManagerCompat.from((Context)context);
        this.cancellationSignal = new CancellationSignal();
        this.fingerprintManagerCompat.authenticate(null, 0, this.cancellationSignal, this.authenticationCallback, null);
    }

    public void cancelSignal() {
        if (this.cancellationSignal != null) {
            this.cancellationSignal.cancel();
        }
    }

    public static boolean hasFingerprintSupport(Context context) {
        KeyguardManager keyguardManager;
        FingerprintManagerCompat fingerprintManager = FingerprintManagerCompat.from((Context)context);
        boolean hardwareSupport = fingerprintManager.isHardwareDetected();
        boolean secureSupport = true;
        if (Build.VERSION.SDK_INT >= 16 && (keyguardManager = (KeyguardManager)context.getSystemService("keyguard")) != null) {
            secureSupport = keyguardManager.isKeyguardSecure();
        }
        boolean hasPwd = fingerprintManager.hasEnrolledFingerprints();
        return hardwareSupport && secureSupport && hasPwd;
    }

    public static interface OnFingerAuthListener {
        public void onSuccess();

        public void onFailure();

        public void onError();
    }
}

