/*
 * Decompiled with CFR 0.152.
 */
package activitystarter.compiler.processing;

import activitystarter.Arg;
import activitystarter.compiler.error.Errors;
import activitystarter.compiler.error.PrintErrorFunKt;
import activitystarter.compiler.model.ConverterModel;
import activitystarter.compiler.model.ProjectConfig;
import activitystarter.compiler.model.classbinding.KnownClassType;
import activitystarter.compiler.model.param.ArgumentModel;
import activitystarter.compiler.model.param.FieldAccessor;
import activitystarter.compiler.model.param.ParamType;
import activitystarter.compiler.processing.ArgumentFactory$WhenMappings;
import activitystarter.compiler.utils.UtillsKt;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J8\u0010\u0016\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\"H\u0002J$\u0010#\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Lactivitystarter/compiler/processing/ArgumentFactory;", "", "enclosingElement", "Ljavax/lang/model/element/TypeElement;", "config", "Lactivitystarter/compiler/model/ProjectConfig;", "(Ljavax/lang/model/element/TypeElement;Lactivitystarter/compiler/model/ProjectConfig;)V", "getConfig", "()Lactivitystarter/compiler/model/ProjectConfig;", "getEnclosingElement", "()Ljavax/lang/model/element/TypeElement;", "create", "Lactivitystarter/compiler/model/param/ArgumentModel;", "element", "Ljavax/lang/model/element/Element;", "packageName", "", "knownClassType", "Lactivitystarter/compiler/model/classbinding/KnownClassType;", "createFromField", "createFromGetter", "getterElement", "getConverterAndSaveType", "Lkotlin/Pair;", "Lactivitystarter/compiler/model/ConverterModel;", "Lactivitystarter/compiler/model/param/ParamType;", "isParceler", "", "elementType", "Ljavax/lang/model/type/TypeMirror;", "paramType", "getFieldError", "paramTypeNullable", "accessor", "Lactivitystarter/compiler/model/param/FieldAccessor;", "getGetterError", "showProcessingError", "", "text", "ProcessingError", "activitystarter-compiler_main"})
public final class ArgumentFactory {
    @NotNull
    private final TypeElement enclosingElement;
    @NotNull
    private final ProjectConfig config;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ArgumentModel create(@NotNull Element element, @NotNull String packageName, @NotNull KnownClassType knownClassType) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)knownClassType), (String)"knownClassType");
        ElementKind elementKind = element.getKind();
        if (elementKind == null) return null;
        switch (ArgumentFactory$WhenMappings.$EnumSwitchMapping$0[elementKind.ordinal()]) {
            case 1: {
                ArgumentModel argumentModel = this.createFromField(element, packageName, knownClassType);
                return argumentModel;
            }
            case 2: {
                ArgumentModel argumentModel = this.createFromGetter(element, packageName, knownClassType);
                return argumentModel;
            }
            default: {
                return null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ArgumentModel createFromField(Element element, String packageName, KnownClassType knownClassType) {
        void converter;
        void saveParamType;
        String string;
        Arg annotation;
        FieldAccessor accessor;
        TypeMirror elementType = UtillsKt.getElementType(element);
        ParamType paramType = ParamType.Companion.fromType(elementType);
        String error = this.getFieldError(knownClassType, paramType, accessor = FieldAccessor.Companion.fromElement(element));
        if (error != null) {
            this.showProcessingError(element, error);
            return null;
        }
        String name = element.getSimpleName().toString();
        Arg arg = annotation = element.getAnnotation(Arg.class);
        String keyFromAnnotation = arg != null ? arg.key() : null;
        Arg arg2 = annotation;
        boolean isParceler = arg2 != null ? arg2.parceler() : false;
        Arg arg3 = annotation;
        boolean optional = arg3 != null ? arg3.optional() : false;
        CharSequence charSequence = keyFromAnnotation;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            string = "" + packageName + '.' + name + "StarterKey";
        } else {
            string = keyFromAnnotation;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        String key = string;
        TypeName typeName = TypeName.get((TypeMirror)elementType);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"TypeName.get(elementType)");
        TypeName typeName2 = typeName;
        Pair<ConverterModel, ParamType> pair = this.getConverterAndSaveType(isParceler, elementType, paramType, element);
        if (pair == null) {
            return null;
        }
        Pair<ConverterModel, ParamType> pair2 = pair;
        ConverterModel converterModel = (ConverterModel)pair2.component1();
        ParamType paramType2 = (ParamType)((Object)pair2.component2());
        pair2 = null;
        return new ArgumentModel(name, key, paramType, typeName2, (ParamType)saveParamType, optional, accessor, (ConverterModel)converter, isParceler);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ArgumentModel createFromGetter(@NotNull Element getterElement, @Nullable String packageName, @NotNull KnownClassType knownClassType) {
        void converter;
        void saveParamType;
        String string;
        Arg annotation;
        ExecutableType getter;
        Intrinsics.checkParameterIsNotNull((Object)getterElement, (String)"getterElement");
        Intrinsics.checkParameterIsNotNull((Object)((Object)knownClassType), (String)"knownClassType");
        if (!StringsKt.startsWith$default((CharSequence)getterElement.getSimpleName(), (CharSequence)"get", (boolean)false, (int)2, null)) {
            this.showProcessingError(getterElement, "Function is not getter");
            return null;
        }
        String name = StringsKt.decapitalize((String)StringsKt.substringAfter$default((String)getterElement.getSimpleName().toString(), (String)"get", null, (int)2, null));
        TypeMirror typeMirror = getterElement.asType();
        if (!(typeMirror instanceof ExecutableType)) {
            typeMirror = null;
        }
        if ((getter = (ExecutableType)typeMirror) == null) {
            this.showProcessingError(getterElement, "Type is not method");
            return null;
        }
        TypeMirror typeMirror2 = getter.getReturnType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"getter.returnType");
        TypeMirror returnType = typeMirror2;
        ParamType paramType = ParamType.Companion.fromType(returnType);
        FieldAccessor accessor = FieldAccessor.Companion.fromGetter(getterElement, name);
        String error = this.getGetterError(knownClassType, paramType, accessor);
        if (error != null) {
            this.showProcessingError(getterElement, error);
            return null;
        }
        Arg arg = annotation = getterElement.getAnnotation(Arg.class);
        String keyFromAnnotation = arg != null ? arg.key() : null;
        Arg arg2 = annotation;
        boolean parceler = arg2 != null ? arg2.parceler() : false;
        Arg arg3 = annotation;
        boolean optional = arg3 != null ? arg3.optional() : false;
        CharSequence charSequence = keyFromAnnotation;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            string = "" + packageName + '.' + name + "StarterKey";
        } else {
            string = keyFromAnnotation;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        String key = string;
        TypeName typeName = TypeName.get((TypeMirror)returnType);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"TypeName.get(returnType)");
        TypeName typeName2 = typeName;
        Pair<ConverterModel, ParamType> pair = this.getConverterAndSaveType(parceler, returnType, paramType, getterElement);
        if (pair == null) {
            return null;
        }
        Pair<ConverterModel, ParamType> pair2 = pair;
        ConverterModel converterModel = (ConverterModel)pair2.component1();
        ParamType paramType2 = (ParamType)((Object)pair2.component2());
        pair2 = null;
        return new ArgumentModel(name, key, paramType, typeName2, (ParamType)saveParamType, optional, accessor, (ConverterModel)converter, parceler);
    }

    private final Pair<ConverterModel, ParamType> getConverterAndSaveType(boolean isParceler, TypeMirror elementType, ParamType paramType, Element element) {
        Object saveParamType;
        if (isParceler) {
            return TuplesKt.to(null, (Object)((Object)ParamType.ParcelableSubtype));
        }
        ConverterModel converter = this.config.converterFor(elementType);
        Object object = converter;
        if (object == null || (object = object.getToParamType()) == null) {
            object = saveParamType = paramType;
        }
        if (Intrinsics.areEqual((Object)saveParamType, (Object)((Object)ParamType.ObjectSubtype))) {
            String string = StringsKt.replace$default((String)Errors.INSTANCE.getNotSupportedType(), (String)"{Type}", (String)paramType.name(), (boolean)false, (int)4, null);
            CharSequence charSequence = element.getSimpleName();
            if (charSequence == null || (charSequence = charSequence.toString()) == null) {
                charSequence = "";
            }
            this.showProcessingError(element, StringsKt.replace$default((String)string, (String)"{Field}", (String)charSequence, (boolean)false, (int)4, null));
            return null;
        }
        return TuplesKt.to((Object)converter, (Object)saveParamType);
    }

    private final String getFieldError(KnownClassType knownClassType, ParamType paramTypeNullable, FieldAccessor accessor) {
        return Intrinsics.areEqual((Object)((Object)this.enclosingElement.getKind()), (Object)((Object)ElementKind.CLASS)) ^ true ? Errors.INSTANCE.getNotAClass() : (this.enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE) ? Errors.INSTANCE.getPrivateClass() : (paramTypeNullable == null ? StringsKt.replace$default((String)StringsKt.replace$default((String)Errors.INSTANCE.getNotSupportedType(), (String)"{Type}", (String)"null", (boolean)false, (int)4, null), (String)"{Field}", (String)accessor.getFieldName(), (boolean)false, (int)4, null) : (!accessor.isAccessible() ? Errors.INSTANCE.getInaccessibleField() : (paramTypeNullable.typeUsedBySupertype() && Intrinsics.areEqual((Object)((Object)knownClassType), (Object)((Object)KnownClassType.BroadcastReceiver)) ? Errors.INSTANCE.getNotBasicTypeInReceiver() : null))));
    }

    private final String getGetterError(KnownClassType knownClassType, ParamType paramTypeNullable, FieldAccessor accessor) {
        return Intrinsics.areEqual((Object)((Object)this.enclosingElement.getKind()), (Object)((Object)ElementKind.CLASS)) ^ true ? Errors.INSTANCE.getNotAClass() : (this.enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE) ? Errors.INSTANCE.getPrivateClass() : (paramTypeNullable == null ? StringsKt.replace$default((String)StringsKt.replace$default((String)Errors.INSTANCE.getNotSupportedType(), (String)"{Type}", (String)"null", (boolean)false, (int)4, null), (String)"{Field}", (String)accessor.getFieldName(), (boolean)false, (int)4, null) : (paramTypeNullable.typeUsedBySupertype() && Intrinsics.areEqual((Object)((Object)knownClassType), (Object)((Object)KnownClassType.BroadcastReceiver)) ? Errors.INSTANCE.getNotBasicTypeInReceiver() : null)));
    }

    private final void showProcessingError(Element element, String text) {
        Element element2 = this.enclosingElement;
        String string = "@%s %s " + text + " (%s)";
        Object[] objectArray = new Object[3];
        String string2 = Arg.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Arg::class.java.simpleName");
        objectArray[0] = string2;
        Name name = this.enclosingElement.getQualifiedName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"enclosingElement.qualifiedName");
        objectArray[1] = name;
        Name name2 = element.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"element.simpleName");
        objectArray[2] = name2;
        PrintErrorFunKt.error(element2, string, objectArray);
    }

    @NotNull
    public final TypeElement getEnclosingElement() {
        return this.enclosingElement;
    }

    @NotNull
    public final ProjectConfig getConfig() {
        return this.config;
    }

    public ArgumentFactory(@NotNull TypeElement enclosingElement, @NotNull ProjectConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)enclosingElement, (String)"enclosingElement");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.enclosingElement = enclosingElement;
        this.config = config;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lactivitystarter/compiler/processing/ArgumentFactory$ProcessingError;", "", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "activitystarter-compiler_main"})
    public static final class ProcessingError
    extends Throwable {
        @NotNull
        private final String message;

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        public ProcessingError(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            super(message);
            this.message = message;
        }
    }
}

