/*
 * Decompiled with CFR 0.152.
 */
package com.marchinram.rxgallery;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Pair;
import com.marchinram.rxgallery.RxGallery;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public final class RxGalleryActivity
extends Activity {
    static final String FINISHED_ACTION = "com.marchinram.rxgallery.FINISHED_ACTION";
    static final String DISPOSED_ACTION = "com.marchinram.rxgallery.DISPOSED_ACTION";
    static final String EXTRA_REQUEST = "extraRequest";
    static final String EXTRA_URIS = "extraUris";
    static final String EXTRA_ERROR_NO_ACTIVITY = "extraErrorNoActivity";
    static final String EXTRA_ERROR_SECURITY = "extraErrorSecurity";
    private static final int RC_GALLERY = 1000;
    private static final int RC_TAKE_PHOTO = 1001;
    private static final int RC_TAKE_VIDEO = 1002;
    private Uri outputUri;
    private final BroadcastReceiver disposedReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            RxGalleryActivity.this.finishAll();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.registerReceiver(this.disposedReceiver, new IntentFilter(DISPOSED_ACTION));
        RxGallery.Request request = (RxGallery.Request)this.getIntent().getParcelableExtra(EXTRA_REQUEST);
        switch (request.getSource()) {
            case GALLERY: {
                this.handleIntentRequestPair(this.getGalleryIntentRequestPair(request));
                break;
            }
            case VIDEO_CAPTURE: {
                this.handleIntentRequestPair(this.getVideoCaptureIntentRequestPair());
                break;
            }
            case PHOTO_CAPTURE: {
                try {
                    this.handleIntentRequestPair(this.getPhotoCaptureIntentRequestPair(request));
                    break;
                }
                catch (SecurityException e) {
                    this.sendErrorSecurity(e);
                }
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.disposedReceiver);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Intent intent = new Intent(FINISHED_ACTION);
        ArrayList<Uri> uris = new ArrayList<Uri>();
        if (resultCode == -1) {
            switch (requestCode) {
                case 1000: {
                    uris = this.handleGallery(data);
                    break;
                }
                case 1002: {
                    uris.add(data.getData());
                    break;
                }
                case 1001: {
                    uris.add(this.outputUri);
                }
            }
        } else if (requestCode == 1001) {
            this.getContentResolver().delete(this.outputUri, null, null);
        }
        intent.putParcelableArrayListExtra(EXTRA_URIS, uris);
        this.sendBroadcast(intent);
        this.finishAll();
    }

    private void finishAll() {
        this.finishActivity(1000);
        this.finishActivity(1001);
        this.finishActivity(1002);
        this.finish();
    }

    private void sendErrorNoActivity() {
        Intent intent = new Intent(FINISHED_ACTION);
        intent.putExtra(EXTRA_ERROR_NO_ACTIVITY, true);
        this.sendBroadcast(intent);
        this.finishAll();
    }

    private void sendErrorSecurity(SecurityException e) {
        Intent intent = new Intent(FINISHED_ACTION);
        intent.putExtra(EXTRA_ERROR_SECURITY, (Serializable)e);
        this.sendBroadcast(intent);
        this.finishAll();
    }

    private void handleIntentRequestPair(Pair<Intent, Integer> intentRequestPair) {
        if (((Intent)intentRequestPair.first).resolveActivity(this.getPackageManager()) != null) {
            this.startActivityForResult((Intent)intentRequestPair.first, (Integer)intentRequestPair.second);
        } else {
            this.sendErrorNoActivity();
        }
    }

    private Pair<Intent, Integer> getGalleryIntentRequestPair(RxGallery.Request request) {
        Intent intent;
        if (Build.VERSION.SDK_INT >= 19) {
            intent = new Intent("android.intent.action.OPEN_DOCUMENT");
            String[] mimeTypes = new String[request.getMimeTypes().size()];
            for (int i = 0; i < mimeTypes.length; ++i) {
                mimeTypes[i] = request.getMimeTypes().get(i).toString();
            }
            intent.putExtra("android.intent.extra.MIME_TYPES", mimeTypes);
            intent.setType("*/*");
        } else {
            intent = new Intent("android.intent.action.GET_CONTENT");
            intent.setType(request.getMimeTypes().get(0).toString());
        }
        if (Build.VERSION.SDK_INT >= 18) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", request.isMultiSelectEnabled());
        }
        if (Build.VERSION.SDK_INT >= 11) {
            intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        }
        intent.addFlags(1);
        return new Pair((Object)intent, (Object)1000);
    }

    private Pair<Intent, Integer> getPhotoCaptureIntentRequestPair(RxGallery.Request request) throws SecurityException {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.outputUri = request.getOutputUri() != null ? request.getOutputUri() : this.createImage();
        intent.putExtra("output", (Parcelable)this.outputUri);
        return new Pair((Object)intent, (Object)1001);
    }

    private Pair<Intent, Integer> getVideoCaptureIntentRequestPair() {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        return new Pair((Object)intent, (Object)1002);
    }

    private Uri createImage() throws SecurityException {
        ContentResolver contentResolver = this.getContentResolver();
        ContentValues cv = new ContentValues();
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        cv.put("title", timeStamp);
        return contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, cv);
    }

    private ArrayList<Uri> handleGallery(Intent data) {
        ClipData clipData;
        ArrayList<Uri> uris = new ArrayList<Uri>();
        if (data.getData() != null) {
            uris.add(data.getData());
        } else if (Build.VERSION.SDK_INT >= 18 && (clipData = data.getClipData()) != null) {
            for (int i = 0; i < clipData.getItemCount(); ++i) {
                uris.add(clipData.getItemAt(i).getUri());
            }
        }
        return uris;
    }
}

