/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.uuid;

import java.util.UUID;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.uuid.UUIDFetcher;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class UUIDMigration {
    private UUIDMigration() {
    }

    public static boolean canReturnUUID() {
        if (!SimpleClans.getInstance().getSettingsManager().isOnlineMode()) {
            return false;
        }
        try {
            Bukkit.class.getDeclaredMethod("getPlayer", UUID.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static UUID getForcedPlayerUUID(String playerDisplayName) {
        Player OnlinePlayer = SimpleClans.getInstance().getServer().getPlayerExact(playerDisplayName);
        OfflinePlayer OfflinePlayer2 = SimpleClans.getInstance().getServer().getOfflinePlayer(playerDisplayName);
        if (OnlinePlayer != null) {
            return OnlinePlayer.getUniqueId();
        }
        for (ClanPlayer cp : SimpleClans.getInstance().getClanManager().getAllClanPlayers()) {
            if (!cp.getName().equalsIgnoreCase(playerDisplayName)) continue;
            return cp.getUniqueId();
        }
        try {
            return UUIDFetcher.getUUIDOf(playerDisplayName);
        }
        catch (Exception ex) {
            if (OfflinePlayer2 != null) {
                return OfflinePlayer2.getUniqueId();
            }
            return null;
        }
    }
}

