/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.MessageFormat;
import java.util.List;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RivalriesCommand {
    public void execute(Player player, String[] arg) {
        SimpleClans plugin = SimpleClans.getInstance();
        String headColor = plugin.getSettingsManager().getPageHeadingsColor();
        String subColor = plugin.getSettingsManager().getPageSubTitleColor();
        if (arg.length != 0) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.0.rivalries"), plugin.getSettingsManager().getCommandClan()));
            return;
        }
        if (!plugin.getPermissionsManager().has(player, "simpleclans.anyone.rivalries")) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            return;
        }
        List<Clan> clans = plugin.getClanManager().getClans();
        plugin.getClanManager().sortClansByKDR(clans);
        ChatBlock chatBlock = new ChatBlock();
        ChatBlock.sendBlank((CommandSender)player);
        ChatBlock.saySingle((CommandSender)player, plugin.getSettingsManager().getServerName() + subColor + " " + plugin.getLang("rivalries") + " " + headColor + Helper.generatePageSeparator(plugin.getSettingsManager().getPageSep()));
        ChatBlock.sendBlank((CommandSender)player);
        ChatBlock.sendMessage((CommandSender)player, headColor + plugin.getLang("legend") + ChatColor.DARK_RED + " [" + plugin.getLang("war") + "]");
        ChatBlock.sendBlank((CommandSender)player);
        chatBlock.setAlignment("l", "l");
        chatBlock.addRow(plugin.getLang("clan"), plugin.getLang("rivals"));
        for (Clan clan : clans) {
            if (!clan.isVerified()) continue;
            chatBlock.addRow("  " + ChatColor.AQUA + clan.getName(), clan.getRivalString(ChatColor.DARK_GRAY + ", "));
        }
        boolean more = chatBlock.sendBlock((CommandSender)player, plugin.getSettingsManager().getPageSize());
        if (more) {
            plugin.getStorageManager().addChatBlock((CommandSender)player, chatBlock);
            ChatBlock.sendBlank((CommandSender)player);
            ChatBlock.sendMessage((CommandSender)player, headColor + MessageFormat.format(plugin.getLang("view.next.page"), plugin.getSettingsManager().getCommandMore()));
        }
        ChatBlock.sendBlank((CommandSender)player);
    }
}

