/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sacredlabyrinth.phaed.simpleclans.CommandHelper;
import net.sacredlabyrinth.phaed.simpleclans.PlayerNameTabCompleter;
import net.sacredlabyrinth.phaed.simpleclans.executors.AcceptCommandExecutor;
import net.sacredlabyrinth.phaed.simpleclans.executors.AllyCommandExecutor;
import net.sacredlabyrinth.phaed.simpleclans.executors.ClanCommandExecutor;
import net.sacredlabyrinth.phaed.simpleclans.executors.DenyCommandExecutor;
import net.sacredlabyrinth.phaed.simpleclans.executors.GlobalCommandExecutor;
import net.sacredlabyrinth.phaed.simpleclans.executors.MoreCommandExecutor;
import net.sacredlabyrinth.phaed.simpleclans.listeners.SCEntityListener;
import net.sacredlabyrinth.phaed.simpleclans.listeners.SCPlayerListener;
import net.sacredlabyrinth.phaed.simpleclans.managers.ClanManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.LanguageManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.PermissionsManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.RequestManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.SettingsManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.StorageManager;
import net.sacredlabyrinth.phaed.simpleclans.managers.TeleportManager;
import net.sacredlabyrinth.phaed.simpleclans.uuid.UUIDMigration;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleClans
extends JavaPlugin {
    private ArrayList<String> messages = new ArrayList();
    private static SimpleClans instance;
    private static final Logger logger;
    private ClanManager clanManager;
    private RequestManager requestManager;
    private StorageManager storageManager;
    private SettingsManager settingsManager;
    private PermissionsManager permissionsManager;
    private TeleportManager teleportManager;
    private LanguageManager languageManager;
    private boolean hasUUID;

    public static Logger getLog() {
        return logger;
    }

    public static void debug(String msg) {
        if (SimpleClans.getInstance().getSettingsManager().isDebugging()) {
            logger.log(Level.INFO, msg);
        }
    }

    public static SimpleClans getInstance() {
        return instance;
    }

    public static void log(String msg, Object ... arg) {
        if (arg == null || arg.length == 0) {
            logger.log(Level.INFO, msg);
        } else {
            logger.log(Level.INFO, MessageFormat.format(msg, arg));
        }
    }

    public void onEnable() {
        instance = this;
        this.settingsManager = new SettingsManager();
        this.hasUUID = UUIDMigration.canReturnUUID();
        this.languageManager = new LanguageManager();
        this.permissionsManager = new PermissionsManager();
        this.requestManager = new RequestManager();
        this.clanManager = new ClanManager();
        this.storageManager = new StorageManager();
        this.teleportManager = new TeleportManager();
        logger.info(MessageFormat.format(this.getLang("version.loaded"), this.getDescription().getName(), this.getDescription().getVersion()));
        this.getServer().getPluginManager().registerEvents((Listener)new SCEntityListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SCPlayerListener(), (Plugin)this);
        this.permissionsManager.loadPermissions();
        CommandHelper.registerCommand(this.getSettingsManager().getCommandClan());
        CommandHelper.registerCommand(this.getSettingsManager().getCommandAccept());
        CommandHelper.registerCommand(this.getSettingsManager().getCommandDeny());
        CommandHelper.registerCommand(this.getSettingsManager().getCommandMore());
        CommandHelper.registerCommand(this.getSettingsManager().getCommandAlly());
        CommandHelper.registerCommand(this.getSettingsManager().getCommandGlobal());
        this.getCommand(this.getSettingsManager().getCommandClan()).setExecutor((CommandExecutor)new ClanCommandExecutor());
        this.getCommand(this.getSettingsManager().getCommandAccept()).setExecutor((CommandExecutor)new AcceptCommandExecutor());
        this.getCommand(this.getSettingsManager().getCommandDeny()).setExecutor((CommandExecutor)new DenyCommandExecutor());
        this.getCommand(this.getSettingsManager().getCommandMore()).setExecutor((CommandExecutor)new MoreCommandExecutor());
        this.getCommand(this.getSettingsManager().getCommandAlly()).setExecutor((CommandExecutor)new AllyCommandExecutor());
        this.getCommand(this.getSettingsManager().getCommandGlobal()).setExecutor((CommandExecutor)new GlobalCommandExecutor());
        this.getCommand(this.getSettingsManager().getCommandClan()).setTabCompleter((TabCompleter)new PlayerNameTabCompleter());
        logger.info("[SimpleClans] Online Mode: " + this.hasUUID);
        logger.info("[SimpleClans] Modo Multithreading: " + SimpleClans.getInstance().getSettingsManager().getUseThreads());
        logger.info("[SimpleClans] Modo BungeeCord: " + SimpleClans.getInstance().getSettingsManager().getUseBungeeCord());
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getStorageManager().closeConnection();
        this.getPermissionsManager().savePermissions();
    }

    public ClanManager getClanManager() {
        return this.clanManager;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public PermissionsManager getPermissionsManager() {
        return this.permissionsManager;
    }

    public String getLang(String msg) {
        return this.languageManager.get(msg);
    }

    public TeleportManager getTeleportManager() {
        return this.teleportManager;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public boolean hasUUID() {
        return this.hasUUID;
    }

    public void setUUID(boolean trueOrFalse) {
        this.hasUUID = trueOrFalse;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    static {
        logger = Logger.getLogger("Minecraft");
    }
}

