/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.uuid.UUIDMigration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;

public class Helper {
    private Helper() {
    }

    public static void dumpStackTrace() {
        for (StackTraceElement el : Thread.currentThread().getStackTrace()) {
            SimpleClans.debug(el.toString());
        }
    }

    public static String getColorName(String playerName) {
        List players = SimpleClans.getInstance().getServer().matchPlayer(playerName);
        if (players.size() == 1) {
            return SimpleClans.getInstance().getPermissionsManager().getPrefix((Player)players.get(0)) + ((Player)players.get(0)).getName() + SimpleClans.getInstance().getPermissionsManager().getSuffix((Player)players.get(0));
        }
        return playerName;
    }

    public static boolean isInteger(Object o) {
        return o instanceof Integer;
    }

    public static boolean isByte(String input) {
        try {
            Byte.parseByte(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isShort(String input) {
        try {
            Short.parseShort(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isFloat(String input) {
        try {
            Float.parseFloat(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isString(Object o) {
        return o instanceof String;
    }

    public static boolean isBoolean(Object o) {
        return o instanceof Boolean;
    }

    public static String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    public static String removeFirstChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
            break;
        }
        return r;
    }

    public static String capitalize(String content) {
        if (content.length() < 2) {
            return content;
        }
        String first = content.substring(0, 1).toUpperCase();
        return first + content.substring(1);
    }

    public static String plural(int count, String word, String ending) {
        return count == 1 ? word : word + ending;
    }

    public static String toColor(String hexValue) {
        if (hexValue == null) {
            return "";
        }
        return ChatColor.getByChar((String)hexValue).toString();
    }

    public static List<String> fromArray(String ... values) {
        ArrayList<String> results = new ArrayList<String>();
        Collections.addAll(results, values);
        results.remove("");
        return results;
    }

    public static Set<String> fromArray2(String ... values) {
        HashSet<String> results = new HashSet<String>();
        Collections.addAll(results, values);
        results.remove("");
        return results;
    }

    public static List<Player> fromPlayerArray(Player ... values) {
        ArrayList<Player> results = new ArrayList<Player>();
        Collections.addAll(results, values);
        return results;
    }

    public static String[] toArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static String[] removeFirst(String[] args) {
        List<String> out = Helper.fromArray(args);
        if (!out.isEmpty()) {
            out.remove(0);
        }
        return Helper.toArray(out);
    }

    public static String toMessage(String[] args) {
        String out = "";
        for (String arg : args) {
            out = out + arg + " ";
        }
        return out.trim();
    }

    public static String toMessage(String[] args, String sep) {
        String out = "";
        for (String arg : args) {
            out = out + arg + ", ";
        }
        return Helper.stripTrailing(out, ", ");
    }

    public static String toMessage(List<String> args, String sep) {
        String out = "";
        for (String arg : args) {
            out = out + arg + sep;
        }
        return Helper.stripTrailing(out, sep);
    }

    public static String parseColors(String msg) {
        return msg.replace("&", "\u00a7");
    }

    public static String stripColors(String msg) {
        String out = msg.replaceAll("[&][0-9a-f]", "");
        out = out.replaceAll(String.valueOf('\u00c2'), "");
        return out.replaceAll("[\u00a7][0-9a-f]", "");
    }

    public static String getLastColorCode(String msg) {
        if ((msg = msg.replaceAll(String.valueOf('\u00c2'), "").trim()).length() < 2) {
            return "";
        }
        String one = msg.substring(msg.length() - 2, msg.length() - 1);
        String two = msg.substring(msg.length() - 1);
        if (one.equals("\u00a7")) {
            return one + two;
        }
        if (one.equals("&")) {
            return Helper.toColor(two);
        }
        return "";
    }

    public static String cleanTag(String tag) {
        return Helper.stripColors(tag).toLowerCase();
    }

    public static String stripTrailing(String msg, String sep) {
        if (msg.length() < sep.length()) {
            return msg;
        }
        String out = msg;
        String first = msg.substring(0, sep.length());
        String last = msg.substring(msg.length() - sep.length(), msg.length());
        if (first.equals(sep)) {
            out = msg.substring(sep.length());
        }
        if (last.equals(sep)) {
            out = msg.substring(0, msg.length() - sep.length());
        }
        return out;
    }

    public static String generatePageSeparator(String sep) {
        String out = "";
        for (int i = 0; i < 320; ++i) {
            out = out + sep;
        }
        return out;
    }

    @Deprecated
    public static boolean isOnline(String playerName) {
        Collection<Player> online = Helper.getOnlinePlayers();
        for (Player o : online) {
            if (!o.getName().equalsIgnoreCase(playerName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnline(UUID playerUniqueId) {
        Collection<Player> online = Helper.getOnlinePlayers();
        for (Player o : online) {
            if (!o.getUniqueId().equals(playerUniqueId)) continue;
            return true;
        }
        return false;
    }

    public static List<ClanPlayer> stripOffLinePlayers(List<ClanPlayer> in) {
        ArrayList<ClanPlayer> out = new ArrayList<ClanPlayer>();
        for (ClanPlayer cp : in) {
            if (cp.toPlayer() == null) continue;
            out.add(cp);
        }
        return out;
    }

    public static boolean testURL(String strUrl) {
        try {
            URL url = new URL(strUrl);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.connect();
            if (urlConn.getResponseCode() != 200) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static String escapeQuotes(String str) {
        if (str == null) {
            return "";
        }
        return str.replace("'", "''");
    }

    public static String toLocationString(Location loc) {
        return loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ() + " " + loc.getWorld().getName();
    }

    public static boolean isSameBlock(Location loc, Location loc2) {
        return loc.getBlockX() == loc2.getBlockX() && loc.getBlockY() == loc2.getBlockY() && loc.getBlockZ() == loc2.getBlockZ();
    }

    public static boolean isSameLocation(Location loc, Location loc2) {
        return loc.getX() == loc2.getX() && loc.getY() == loc2.getY() && loc.getZ() == loc2.getZ();
    }

    public static Map sortByValue(Map map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o2).getValue()).compareTo(((Map.Entry)o1).getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static boolean isVanished(Player player) {
        if (player != null && player.hasMetadata("vanished") && !player.getMetadata("vanished").isEmpty()) {
            return ((MetadataValue)player.getMetadata("vanished").get(0)).asBoolean();
        }
        return false;
    }

    public static Collection<Player> getOnlinePlayers() {
        try {
            Method method = Bukkit.class.getDeclaredMethod("getOnlinePlayers", new Class[0]);
            Object players = method.invoke(null, new Object[0]);
            if (players instanceof Player[]) {
                return new ArrayList<Player>(Arrays.asList((Player[])players));
            }
            return (Collection)players;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Player>();
        }
    }

    public static Player getPlayer(String playerName) {
        if (SimpleClans.getInstance().hasUUID()) {
            return SimpleClans.getInstance().getServer().getPlayer(UUIDMigration.getForcedPlayerUUID(playerName));
        }
        return SimpleClans.getInstance().getServer().getPlayer(playerName);
    }
}

