/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.wrapper.yaml;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.mapfish.print.wrapper.ObjectMissingException;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PElement;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonArray;
import org.mapfish.print.wrapper.yaml.PYamlObject;

public class PYamlArray
extends PElement
implements PArray {
    private final List<Object> array;

    public PYamlArray(PElement parent, List<Object> array, String contextName) {
        super(parent, contextName);
        this.array = array;
    }

    @Override
    public final int size() {
        return this.array.size();
    }

    @Override
    public final PObject getObject(int i) {
        Map val = (Map)this.array.get(i);
        String context = "[" + i + "]";
        if (val == null) {
            throw new ObjectMissingException(this, context);
        }
        return new PYamlObject(this, val, context);
    }

    @Override
    public final PArray getArray(int i) {
        List val = (List)this.array.get(i);
        String context = "[" + i + "]";
        if (val == null) {
            throw new ObjectMissingException(this, context);
        }
        return new PYamlArray(this, val, context);
    }

    @Override
    public final int getInt(int i) {
        return (Integer)this.array.get(i);
    }

    @Override
    public final long getLong(int i) {
        Number result = (Number)this.array.get(i);
        return result.longValue();
    }

    @Override
    public final float getFloat(int i) {
        Number result = (Number)this.array.get(i);
        return result.floatValue();
    }

    @Override
    public final double getDouble(int i) {
        Number result = (Number)this.array.get(i);
        return result.doubleValue();
    }

    @Override
    public final String getString(int i) {
        return (String)this.array.get(i);
    }

    @Override
    public final boolean getBool(int i) {
        return (Boolean)this.array.get(i);
    }

    @Override
    public final Object get(int i) {
        Object o = this.array.get(i);
        if (o instanceof Map) {
            Map map = (Map)o;
            return new PYamlObject(this, map, String.valueOf(i));
        }
        if (o instanceof List) {
            List objects = (List)o;
            return new PYamlArray(this, objects, String.valueOf(i));
        }
        if (o != null && o.getClass().isArray()) {
            List<Object> objects = Arrays.asList((Object[])o);
            return new PYamlArray(this, objects, String.valueOf(i));
        }
        return o;
    }

    public final String toString() {
        return "PYaml(" + this.getCurrentPath() + ":" + this.toJSON().getInternalArray().toString(2) + ")";
    }

    public final PJsonArray toJSON() {
        JSONArray jsonArray = new JSONArray();
        int size = this.array.size();
        for (int i = 0; i < size; ++i) {
            Object o = this.get(i);
            if (o instanceof PYamlObject) {
                PYamlObject pYamlObject = (PYamlObject)o;
                jsonArray.put((Object)pYamlObject.toJSON().getInternalObj());
                continue;
            }
            if (o instanceof PYamlArray) {
                PYamlArray pYamlArray = (PYamlArray)o;
                jsonArray.put((Object)pYamlArray.toJSON().getInternalArray());
                continue;
            }
            jsonArray.put(o);
        }
        return new PJsonArray(null, jsonArray, this.getContextName());
    }
}

