/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.servlet.job.PrintJobResult;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.PrintJobEntryImpl;
import org.mapfish.print.servlet.job.impl.PrintJobResultImpl;

@Entity
@Table(name="print_job_statuses")
public class PrintJobStatusImpl
implements PrintJobStatus {
    @Embedded
    @Target(value=PrintJobEntryImpl.class)
    private final PrintJobEntry entry;
    @Id
    @Type(type="org.hibernate.type.TextType")
    private String referenceId;
    @Column
    @Enumerated(value=EnumType.STRING)
    private PrintJobStatus.Status status = PrintJobStatus.Status.WAITING;
    @Column
    private Long completionTime;
    @Column
    private long requestCount;
    @Type(type="org.hibernate.type.TextType")
    private String error;
    @OneToOne(targetEntity=PrintJobResultImpl.class, cascade={CascadeType.ALL}, mappedBy="status")
    @JoinColumn(name="reference_id")
    private PrintJobResult result;
    private transient long waitingTime;
    private transient Long statusTime;

    public PrintJobStatusImpl() {
        this.entry = null;
    }

    public PrintJobStatusImpl(PrintJobEntry entry, long requestCount) {
        this.referenceId = entry.getReferenceId();
        this.entry = entry;
        this.requestCount = requestCount;
    }

    @Override
    public PrintJobEntry getEntry() {
        return this.entry;
    }

    @Override
    public Long getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(Long completionTime) {
        this.completionTime = completionTime;
    }

    @Override
    public long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(long requestCount) {
        this.requestCount = requestCount;
    }

    @Override
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    @Override
    public PrintJobStatus.Status getStatus() {
        return this.status;
    }

    public void setStatus(PrintJobStatus.Status status) {
        this.status = status;
    }

    @Override
    public PrintJobResult getResult() {
        return this.result;
    }

    public void setResult(PrintJobResult result) {
        this.result = result;
    }

    @Override
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public long getStartTime() {
        return this.getEntry().getStartTime();
    }

    @Override
    public AccessAssertion getAccess() {
        return this.getEntry().getAccess();
    }

    @Override
    public String getAppId() {
        return this.getEntry().getAppId();
    }

    @Override
    public Date getStartDate() {
        return this.getEntry().getStartDate();
    }

    @Override
    public Date getCompletionDate() {
        return this.getCompletionTime() == null ? null : new Date(this.getCompletionTime());
    }

    @Override
    public long getElapsedTime() {
        if (this.completionTime != null) {
            return this.completionTime - this.getEntry().getStartTime();
        }
        if (this.statusTime != null) {
            return this.statusTime - this.getEntry().getStartTime();
        }
        return System.currentTimeMillis() - this.getEntry().getStartTime();
    }

    @Override
    public boolean isDone() {
        return this.getStatus() != PrintJobStatus.Status.RUNNING && this.getStatus() != PrintJobStatus.Status.WAITING;
    }

    @Override
    public long getWaitingTime() {
        return this.waitingTime;
    }

    @Override
    public void setWaitingTime(long waitingTime) {
        this.waitingTime = waitingTime;
    }

    public Long getStatusTime() {
        return this.statusTime;
    }

    public void setStatusTime(Long statusTime) {
        this.statusTime = statusTime;
    }
}

