/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mapfish.print.PrintException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public abstract class BaseMapServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMapServlet.class);
    private int cacheDurationInSeconds = 3600;

    protected static void error(HttpServletResponse httpServletResponse, String message, HttpStatus code) {
        try {
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setStatus(code.value());
            BaseMapServlet.setNoCache(httpServletResponse);
            try (PrintWriter out = httpServletResponse.getWriter();){
                out.println("Error while processing request:");
                out.println(message);
            }
            LOGGER.warn("Error while processing request: {}", (Object)message);
        }
        catch (IOException ex) {
            throw new PrintException("Failed to send an error", ex);
        }
    }

    protected static void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "max-age=0, must-revalidate, no-cache, no-store");
    }

    protected final StringBuilder getBaseUrl(HttpServletRequest httpServletRequest) {
        StringBuilder baseURL = new StringBuilder();
        if (httpServletRequest.getContextPath() != null && !httpServletRequest.getContextPath().isEmpty()) {
            baseURL.append(httpServletRequest.getContextPath());
        }
        if (httpServletRequest.getServletPath() != null && !httpServletRequest.getServletPath().isEmpty()) {
            baseURL.append(httpServletRequest.getServletPath());
        }
        return baseURL;
    }

    public final void setCacheDuration(int cacheDurationInSeconds) {
        this.cacheDurationInSeconds = cacheDurationInSeconds;
    }

    protected void setCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "max-age=" + this.cacheDurationInSeconds);
    }
}

