/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.mapfish.print.ImageUtils;
import org.mapfish.print.attribute.map.MapLayer;

class ImageWriter {
    private final File printDirectory;
    private final String mapKey;
    private final String formatName;
    private final BufferedImage bufferedImage;
    private final List<URI> graphics;
    private int currentFileNumber;

    ImageWriter(File printDirectory, String mapKey, boolean isLayerGroupOpaque, MapLayer.RenderType renderType, int fileNumber, BufferedImage bufferedImage, List<URI> graphics) {
        this.printDirectory = printDirectory;
        this.mapKey = mapKey;
        this.formatName = isLayerGroupOpaque && renderType == MapLayer.RenderType.JPEG ? "JPEG" : "PNG";
        this.currentFileNumber = fileNumber;
        this.bufferedImage = bufferedImage;
        this.graphics = graphics;
    }

    public void writeImage() throws IOException {
        File path = new File(this.printDirectory, String.format("%s_layer_%d.%s", this.mapKey, this.currentFileNumber++, this.formatName.toLowerCase()));
        ImageUtils.writeImage(this.bufferedImage, this.formatName, path);
        this.graphics.add(path.toURI());
    }

    public int getCurrentFileNumber() {
        return this.currentFileNumber;
    }
}

