/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import org.mapfish.print.processor.http.matcher.AcceptAllMatcher;
import org.mapfish.print.processor.http.matcher.MatchInfo;
import org.mapfish.print.processor.http.matcher.URIMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public final class UriMatchers {
    private static final Logger LOGGER = LoggerFactory.getLogger(UriMatchers.class);
    private List<? extends URIMatcher> matchers;

    public UriMatchers() {
        this.matchers = Collections.singletonList(new AcceptAllMatcher());
    }

    public UriMatchers(List<? extends URIMatcher> matchers) {
        this.matchers = matchers;
    }

    public void setMatchers(List<? extends URIMatcher> matchers) {
        this.matchers = matchers;
    }

    public boolean matches(URI uri, HttpMethod httpMethod) throws SocketException, UnknownHostException, MalformedURLException {
        MatchInfo matchInfo = MatchInfo.fromUri(uri, httpMethod);
        return this.matches(matchInfo);
    }

    public boolean matches(MatchInfo matchInfo) throws SocketException, UnknownHostException, MalformedURLException {
        for (URIMatcher uRIMatcher : this.matchers) {
            if (!uRIMatcher.matches(matchInfo)) continue;
            if (uRIMatcher.isReject()) {
                LOGGER.debug("Reject {} because of this rule: {}", (Object)matchInfo, (Object)uRIMatcher);
                return false;
            }
            LOGGER.debug("Accept {} because of this rule: {}", (Object)matchInfo, (Object)uRIMatcher);
            return true;
        }
        LOGGER.debug("Reject {} because no rule matches", (Object)matchInfo);
        return false;
    }

    public void validate(List<Throwable> validationErrors) {
        if (this.matchers == null) {
            validationErrors.add(new IllegalArgumentException("Matchers cannot be null.  There should be at least a !acceptAll matcher"));
        }
        if (this.matchers != null && this.matchers.isEmpty()) {
            validationErrors.add(new IllegalArgumentException("There are no url matchers defined.  There should be at least a !acceptAll matcher"));
        }
    }
}

