/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mapfish.print.processor.Processor;

public class ProcessorDependency {
    private final Class<? extends Processor<?, ?>> required;
    private final Class<? extends Processor<?, ?>> dependent;
    private final Set<String> commonInputs;

    public ProcessorDependency(Class<? extends Processor<?, ?>> required, Class<? extends Processor<?, ?>> dependent, Set<String> commonInputs) {
        this.required = required;
        this.dependent = dependent;
        this.commonInputs = new HashSet<String>(commonInputs);
    }

    public ProcessorDependency(Class<? extends Processor<?, ?>> required, Class<? extends Processor<?, ?>> dependent) {
        this(required, dependent, new HashSet<String>());
    }

    public final Class<? extends Processor<?, ?>> getRequired() {
        return this.required;
    }

    public final Class<? extends Processor<?, ?>> getDependent() {
        return this.dependent;
    }

    public final Set<String> getCommonInputs() {
        return Collections.unmodifiableSet(this.commonInputs);
    }

    public final void addCommonInput(String inputName) {
        this.commonInputs.add(inputName);
    }

    public final String toString() {
        return "ProcessorDependency{required=" + this.required.getSimpleName() + ", dependent=" + this.dependent.getSimpleName() + ", commonInputs=" + this.commonInputs + "}";
    }
}

