/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.mapfish.print.ImageUtils;
import org.mapfish.print.output.AbstractJasperReportOutputFormat;
import org.mapfish.print.output.OutputFormat;

public final class JasperReportImageOutputFormat
extends AbstractJasperReportOutputFormat
implements OutputFormat {
    public static final Map<String, Integer> IMAGE_TYPES = Map.ofEntries(Map.entry("png", 6), Map.entry("jpg", 5), Map.entry("jpeg", 5), Map.entry("tif", 6), Map.entry("tiff", 6), Map.entry("gif", 6), Map.entry("bmp", 5));
    private String fileSuffix;

    @Override
    public String getContentType() {
        return "image/" + this.fileSuffix;
    }

    @Override
    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExport(OutputStream outputStream, AbstractJasperReportOutputFormat.Print print) throws JRException, IOException {
        JasperPrint jasperPrint = print.print;
        int numPages = jasperPrint.getPages().size();
        float dpiRatio = (float)(print.dpi / 72.0);
        int pageHeightOnImage = (int)((float)jasperPrint.getPageHeight() * dpiRatio);
        int pageWidthOnImage = (int)((float)jasperPrint.getPageWidth() * dpiRatio);
        boolean separatorHeight = true;
        int separatorHeightOnImage = (int)(1.0f * dpiRatio);
        int imageType = IMAGE_TYPES.get(this.getFileSuffix().toLowerCase());
        BufferedImage reportImage = new BufferedImage(pageWidthOnImage, numPages * pageHeightOnImage + (numPages - 1) * separatorHeightOnImage, imageType);
        Graphics2D graphics2D = reportImage.createGraphics();
        if (imageType != 6) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, pageWidthOnImage, pageHeightOnImage);
        }
        try {
            JasperPrintManager printManager = JasperPrintManager.getInstance((JasperReportsContext)print.context);
            for (int pageIndex = 0; pageIndex < numPages; ++pageIndex) {
                Image pageImage = printManager.printToImage(jasperPrint, pageIndex, dpiRatio);
                graphics2D.drawImage(pageImage, 0, (pageHeightOnImage + 1) * pageIndex, pageWidthOnImage, (pageHeightOnImage + 1) * pageIndex + pageHeightOnImage, 0, 0, pageWidthOnImage, pageHeightOnImage, null);
            }
            BasicStroke stroke = new BasicStroke(separatorHeightOnImage);
            for (int pageIndex = 0; pageIndex < numPages - 1; ++pageIndex) {
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(stroke);
                int y = (pageHeightOnImage + 1) * pageIndex + pageHeightOnImage;
                graphics2D.drawLine(0, y, pageWidthOnImage, y);
            }
        }
        finally {
            graphics2D.dispose();
        }
        ImageUtils.writeImage(reportImage, this.getFileSuffix(), outputStream);
    }
}

