/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.wms;

import com.codahale.metrics.MetricRegistry;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import org.geotools.api.referencing.FactoryException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.image.wms.WmsLayer;
import org.mapfish.print.map.image.wms.WmsUtilities;
import org.mapfish.print.map.tiled.AbstractTiledLayer;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.wms.TiledWmsLayerParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequest;

public final class TiledWmsLayer
extends AbstractTiledLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TiledWmsLayer.class);
    private final TiledWmsLayerParam param;

    public TiledWmsLayer(@Nonnull ForkJoinPool forkJoinPool, @Nonnull StyleSupplier<GridCoverage2D> styleSupplier, @Nonnull TiledWmsLayerParam param, @Nonnull MetricRegistry registry, @Nonnull Configuration configuration) {
        super(forkJoinPool, styleSupplier, param, registry, configuration);
        this.param = param;
    }

    public TiledWmsLayer(WmsLayer wmsLayer, Dimension tileSize, int tileBufferWidth, int tileBufferHeight) {
        super(wmsLayer, wmsLayer.getStyleSupplier(), wmsLayer.getRegistry(), wmsLayer.getConfiguration());
        this.param = new TiledWmsLayerParam(wmsLayer.getParams(), tileSize, tileBufferWidth, tileBufferHeight);
    }

    public TiledWmsLayerParam getParams() {
        return this.param;
    }

    @Override
    protected TileCacheInformation createTileInformation(MapBounds bounds, Rectangle paintArea, double dpi) {
        return new WmsTileCacheInformation(bounds, paintArea, dpi);
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.fromMimeType(this.param.imageFormat);
    }

    private final class WmsTileCacheInformation
    extends TileCacheInformation {
        private WmsTileCacheInformation(MapBounds bounds, Rectangle paintArea, double dpi) {
            super(bounds, paintArea, dpi, TiledWmsLayer.this.param);
        }

        @Override
        @Nonnull
        public ClientHttpRequest getTileRequest(MfClientHttpRequestFactory httpRequestFactory, String commonUrl, ReferencedEnvelope tileBounds, Dimension tileSizeOnScreen, int column, int row) throws IOException, URISyntaxException, FactoryException {
            CroppedStuff croppedStuff = this.cropOutOfBoundTiles(tileBounds, tileSizeOnScreen);
            URI uri = WmsUtilities.makeWmsGetLayerRequest(TiledWmsLayer.this.param, new URI(commonUrl), croppedStuff.sizeOnScreen, this.dpi, 0.0, croppedStuff.tileBounds);
            LOGGER.info("Tiled WMS query: {}", (Object)uri);
            return WmsUtilities.createWmsRequest(httpRequestFactory, uri, TiledWmsLayer.this.param.method);
        }

        private CroppedStuff cropOutOfBoundTiles(ReferencedEnvelope tileBounds, Dimension sizeOnScreen) {
            Dimension croppedSizeOnScreen;
            ReferencedEnvelope croppedTileBounds;
            ReferencedEnvelope mapBounds = this.getTileCacheBounds();
            if (tileBounds.getMaxX() > mapBounds.getMaxX()) {
                double origWidth = tileBounds.getWidth();
                croppedTileBounds = new ReferencedEnvelope(tileBounds.getMinX(), mapBounds.getMaxX(), tileBounds.getMinY(), tileBounds.getMaxY(), tileBounds.getCoordinateReferenceSystem());
                croppedSizeOnScreen = new Dimension((int)Math.round((double)sizeOnScreen.width * croppedTileBounds.getWidth() / origWidth), sizeOnScreen.height);
            } else {
                croppedTileBounds = tileBounds;
                croppedSizeOnScreen = sizeOnScreen;
            }
            return new CroppedStuff(croppedTileBounds, croppedSizeOnScreen);
        }

        @Override
        public double getResolution() {
            ReferencedEnvelope cacheBounds = this.getTileCacheBounds();
            return cacheBounds.getWidth() / (double)this.paintArea.width;
        }

        @Override
        public Double getLayerDpi() {
            return this.dpi;
        }

        @Override
        public Dimension getTileSize() {
            return TiledWmsLayer.this.param.getTileSize();
        }

        @Override
        public int getTileBufferHeight() {
            return TiledWmsLayer.this.param.getTileBufferHeight();
        }

        @Override
        public int getTileBufferWidth() {
            return TiledWmsLayer.this.param.getTileBufferWidth();
        }

        @Override
        @Nonnull
        protected ReferencedEnvelope getTileCacheBounds() {
            return new ReferencedEnvelope((Envelope)this.bounds.toReferencedEnvelope(this.paintArea), this.bounds.getProjection());
        }

        private final class CroppedStuff {
            final ReferencedEnvelope tileBounds;
            final Dimension sizeOnScreen;

            private CroppedStuff(ReferencedEnvelope tileBounds, Dimension sizeOnScreen) {
                this.tileBounds = tileBounds;
                this.sizeOnScreen = sizeOnScreen;
            }
        }
    }
}

