/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.tiled.AbstractTiledLayerParams;
import org.springframework.http.client.ClientHttpRequest;

public abstract class TileCacheInformation {
    protected final MapBounds bounds;
    protected final Rectangle paintArea;
    protected final double dpi;
    private final AbstractTiledLayerParams params;

    protected TileCacheInformation(MapBounds bounds, Rectangle paintArea, double dpi, AbstractTiledLayerParams params) {
        this.bounds = bounds;
        this.paintArea = paintArea;
        this.dpi = dpi;
        this.params = params;
    }

    @Nonnull
    public abstract ClientHttpRequest getTileRequest(MfClientHttpRequestFactory var1, String var2, ReferencedEnvelope var3, Dimension var4, int var5, int var6) throws Exception;

    public abstract double getResolution();

    public abstract Double getLayerDpi();

    public abstract Dimension getTileSize();

    public int getTileBufferWidth() {
        return 0;
    }

    public int getTileBufferHeight() {
        return 0;
    }

    @Nonnull
    protected abstract ReferencedEnvelope getTileCacheBounds();

    @Nonnull
    public Coordinate getMinGeoCoordinate(ReferencedEnvelope envelope, Coordinate geoTileSize) {
        ReferencedEnvelope tileCacheBounds = this.getTileCacheBounds();
        double tileCacheMinX = tileCacheBounds.getMinX();
        double minGeoX = envelope.getMinX();
        double minGeoY = envelope.getMinY();
        double tileMinGeoX = tileCacheMinX + Math.floor((minGeoX - tileCacheMinX) / geoTileSize.x) * geoTileSize.x;
        double tileCacheMinY = tileCacheBounds.getMinY();
        double tileMinGeoY = tileCacheMinY + Math.floor((minGeoY - tileCacheMinY) / geoTileSize.y) * geoTileSize.y;
        return new Coordinate(tileMinGeoX, tileMinGeoY);
    }

    @Nonnull
    public BufferedImage createBufferedImage(int imageWidth, int imageHeight) {
        return new BufferedImage(imageWidth, imageHeight, 6);
    }

    protected String createCommonUrl() throws URISyntaxException, UnsupportedEncodingException {
        return this.params.createCommonUrl();
    }

    @Nullable
    public BufferedImage getMissingTileImage() {
        return null;
    }
}

