/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.style.Style;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.mapfish.print.PrintException;
import org.mapfish.print.StatsUtils;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.http.Utils;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.AbstractGeotoolsLayer;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public abstract class AbstractSingleImageLayer
extends AbstractGeotoolsLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSingleImageLayer.class);
    @Nonnull
    protected final MetricRegistry registry;
    protected final Configuration configuration;
    private final StyleSupplier<GridCoverage2D> styleSupplier;

    protected AbstractSingleImageLayer(ExecutorService executorService, StyleSupplier<GridCoverage2D> styleSupplier, AbstractLayerParams params, @Nonnull MetricRegistry registry, Configuration configuration) {
        super(executorService, params);
        this.styleSupplier = styleSupplier;
        this.registry = registry;
        this.configuration = configuration;
    }

    @Override
    protected final List<? extends Layer> getLayers(MfClientHttpRequestFactory httpRequestFactory, MapfishMapContext mapContext, Processor.ExecutionContext context) {
        BufferedImage image;
        try {
            image = this.loadImage(httpRequestFactory, mapContext);
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Exception t) {
            throw new PrintException("Failed to LoadImage", t);
        }
        MapBounds bounds = mapContext.getBounds();
        ReferencedEnvelope mapEnvelope = bounds.toReferencedEnvelope(mapContext.getPaintArea());
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GeneralBounds gridEnvelope = new GeneralBounds(mapEnvelope.getCoordinateReferenceSystem());
        gridEnvelope.setEnvelope(new double[]{mapEnvelope.getMinX(), mapEnvelope.getMinY(), mapEnvelope.getMaxX(), mapEnvelope.getMaxY()});
        String coverageName = this.getClass().getSimpleName();
        GridCoverage2D gridCoverage2D = factory.create((CharSequence)coverageName, (RenderedImage)image, (Bounds)gridEnvelope, null, null, null);
        Style style = this.styleSupplier.load(httpRequestFactory, gridCoverage2D);
        return Collections.singletonList(new GridCoverageLayer(gridCoverage2D, style));
    }

    protected abstract BufferedImage loadImage(MfClientHttpRequestFactory var1, MapfishMapContext var2) throws Exception;

    @Override
    public double getImageBufferScaling() {
        return 1.0;
    }

    public StyleSupplier<GridCoverage2D> getStyleSupplier() {
        return this.styleSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage createErrorImage(Rectangle area) {
        BufferedImage bufferedImage = new BufferedImage(area.width, area.height, 3);
        Graphics2D graphics = bufferedImage.createGraphics();
        try {
            graphics.setBackground(ColorParser.toColor(this.configuration.getTransparentTileErrorColor()));
            graphics.clearRect(0, 0, area.width, area.height);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            graphics.dispose();
        }
    }

    protected BufferedImage fetchImage(@Nonnull ClientHttpRequest request, @Nonnull MapfishMapContext transformer) throws IOException {
        String baseMetricName = this.getBaseMetricName(request);
        try (Timer.Context ignored = this.registry.timer(baseMetricName).time();){
            BufferedImage bufferedImage;
            block22: {
                ClientHttpResponse httpResponse;
                block20: {
                    BufferedImage bufferedImage2;
                    block21: {
                        String invalidRespBody;
                        List contentType;
                        block18: {
                            BufferedImage bufferedImage3;
                            block19: {
                                httpResponse = request.execute();
                                try {
                                    contentType = httpResponse.getHeaders().get((Object)"Content-Type");
                                    invalidRespBody = AbstractSingleImageLayer.getInvalidResponseBody(request, contentType, httpResponse);
                                    if (this.isResponseStatusCodeValid(request, httpResponse, invalidRespBody, baseMetricName)) break block18;
                                    bufferedImage3 = this.createErrorImage(transformer.getPaintArea());
                                    if (httpResponse == null) break block19;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (httpResponse != null) {
                                            try {
                                                httpResponse.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (RuntimeException e) {
                                        this.registry.counter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"error"})).inc();
                                        throw e;
                                    }
                                }
                                httpResponse.close();
                            }
                            return bufferedImage3;
                        }
                        if (this.isResponseBodyValid(invalidRespBody, request, contentType, baseMetricName)) break block20;
                        bufferedImage2 = this.createErrorImage(transformer.getPaintArea());
                        if (httpResponse == null) break block21;
                        httpResponse.close();
                    }
                    return bufferedImage2;
                }
                bufferedImage = this.fetchImageFromHttpResponse(request, httpResponse, transformer, baseMetricName);
                if (httpResponse == null) break block22;
                httpResponse.close();
            }
            return bufferedImage;
        }
    }

    private String getBaseMetricName(@Nonnull ClientHttpRequest request) {
        return MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{"read", StatsUtils.quotePart(request.getURI().getHost())});
    }

    private static String getInvalidResponseBody(ClientHttpRequest request, List<String> contentType, ClientHttpResponse httpResponse) throws IOException {
        if (contentType == null || contentType.size() != 1) {
            LOGGER.debug("The image {} didn't return a valid content type header.", (Object)request.getURI());
        } else if (!contentType.get(0).startsWith("image/")) {
            byte[] data;
            try (InputStream body = httpResponse.getBody();){
                data = IOUtils.toByteArray((InputStream)body);
            }
            return new String(data, StandardCharsets.UTF_8);
        }
        return null;
    }

    private boolean isResponseStatusCodeValid(ClientHttpRequest request, ClientHttpResponse httpResponse, String stringBody, String baseMetricName) throws IOException {
        if (httpResponse.getRawStatusCode() != HttpStatus.OK.value()) {
            Object message = String.format("Invalid status code for %s (%d!=%d), status: %s. With request headers:\n%s\nThe response was: '%s'\nWith response headers:\n%s", request.getURI(), httpResponse.getRawStatusCode(), HttpStatus.OK.value(), httpResponse.getStatusText(), String.join((CharSequence)"\n", Utils.getPrintableHeadersList((Map<String, List<String>>)request.getHeaders())), httpResponse.getStatusText(), String.join((CharSequence)"\n", Utils.getPrintableHeadersList((Map<String, List<String>>)httpResponse.getHeaders())));
            if (stringBody != null) {
                message = (String)message + "\nContent:\n" + stringBody;
            }
            this.registry.counter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"error"})).inc();
            if (this.getFailOnError()) {
                throw new RuntimeException((String)message);
            }
            LOGGER.warn((String)message);
            return false;
        }
        return true;
    }

    private boolean isResponseBodyValid(String responseBody, ClientHttpRequest request, List<String> contentType, String baseMetricName) {
        if (responseBody != null) {
            LOGGER.debug("We get a wrong image for {}, content type: {}\nresult:\n{}", new Object[]{request.getURI(), contentType.get(0), responseBody});
            this.registry.counter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"error"})).inc();
            if (this.getFailOnError()) {
                throw new RuntimeException("Wrong content-type : " + contentType.get(0));
            }
            return false;
        }
        return true;
    }

    private BufferedImage fetchImageFromHttpResponse(ClientHttpRequest request, ClientHttpResponse httpResponse, MapfishMapContext transformer, String baseMetricName) throws IOException {
        BufferedImage image = ImageIO.read(httpResponse.getBody());
        if (image == null) {
            LOGGER.warn("Cannot read image from {}", (Object)request.getURI());
            this.registry.counter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"error"})).inc();
            if (this.getFailOnError()) {
                throw new RuntimeException("Cannot read image from " + request.getURI());
            }
            return this.createErrorImage(transformer.getPaintArea());
        }
        return image;
    }
}

