/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import java.awt.geom.AffineTransform;
import javax.annotation.Nonnull;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.style.Style;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.geotools.grid.GridType;
import org.mapfish.print.map.geotools.grid.GridUtils;
import org.mapfish.print.map.geotools.grid.LabelPositionCollector;
import org.mapfish.print.map.geotools.grid.LineGridStyle;
import org.mapfish.print.map.geotools.grid.LinearCoordinateSequence;

final class LineGridStrategy
implements GridType.GridTypeStrategy {
    LineGridStrategy() {
    }

    @Override
    public Style defaultStyle(Template template, GridParam layerData) {
        return LineGridStyle.get(layerData);
    }

    @Override
    public FeatureSourceSupplier createFeatureSource(Template template, final GridParam layerData, final LabelPositionCollector labels) {
        return new FeatureSourceSupplier(){

            @Override
            @Nonnull
            public FeatureSource load(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext mapContext) {
                SimpleFeatureType featureType = GridUtils.createGridFeatureType(mapContext, LineString.class);
                SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
                DefaultFeatureCollection features = layerData.numberOfLines != null ? LineGridStrategy.this.createFeaturesFromNumberOfLines(mapContext, featureBuilder, layerData, labels) : LineGridStrategy.this.createFeaturesFromSpacing(mapContext, featureBuilder, layerData, labels);
                return new CollectionFeatureSource((SimpleFeatureCollection)features);
            }
        };
    }

    @Nonnull
    private DefaultFeatureCollection createFeaturesFromNumberOfLines(@Nonnull MapfishMapContext mapContext, @Nonnull SimpleFeatureBuilder featureBuilder, @Nonnull GridParam layerData, @Nonnull LabelPositionCollector labels) {
        SpacesAndMins fromLinesNbr = this.fromNumberOfLines(mapContext, layerData);
        return this.sharedCreateFeatures(labels, featureBuilder, layerData, mapContext, fromLinesNbr);
    }

    private SpacesAndMins fromNumberOfLines(MapfishMapContext mapContext, GridParam layerData) {
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        double xSpace = bounds.getWidth() / (double)(layerData.numberOfLines[0] + 1);
        double ySpace = bounds.getHeight() / (double)(layerData.numberOfLines[1] + 1);
        double minX = bounds.getMinimum(0) + xSpace;
        double minY = bounds.getMinimum(1) + ySpace;
        return new SpacesAndMins(xSpace, ySpace, minX, minY);
    }

    @Nonnull
    private DefaultFeatureCollection createFeaturesFromSpacing(@Nonnull MapfishMapContext mapContext, @Nonnull SimpleFeatureBuilder featureBuilder, @Nonnull GridParam layerData, @Nonnull LabelPositionCollector labels) {
        SpacesAndMins fromSpacing = this.fromSpacing(mapContext, layerData);
        return this.sharedCreateFeatures(labels, featureBuilder, layerData, mapContext, fromSpacing);
    }

    private SpacesAndMins fromSpacing(MapfishMapContext mapContext, GridParam layerData) {
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        double xSpace = layerData.spacing[0];
        double ySpace = layerData.spacing[1];
        double minX = GridUtils.calculateFirstLine(bounds, layerData, 0);
        double minY = GridUtils.calculateFirstLine(bounds, layerData, 1);
        return new SpacesAndMins(xSpace, ySpace, minX, minY);
    }

    private DefaultFeatureCollection sharedCreateFeatures(LabelPositionCollector labels, SimpleFeatureBuilder featureBuilder, GridParam layerData, MapfishMapContext mapContext, SpacesAndMins spacesAndMins) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        CoordinateReferenceSystem mapCrs = bounds.getCoordinateReferenceSystem();
        String unit = layerData.calculateLabelUnit(mapCrs);
        MathTransform labelTransform = layerData.calculateLabelTransform(mapCrs);
        AxisDirection direction = bounds.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getDirection();
        int numDimensions = bounds.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        Polygon rotatedBounds = GridUtils.calculateBounds(mapContext);
        AffineTransform worldToScreenTransform = GridUtils.getWorldToScreenTransform(mapContext);
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        double pointSpacing = bounds.getSpan(1) / (double)layerData.pointsInLine;
        int i = 0;
        for (double x = spacesAndMins.minX; x < bounds.getMaxX(); x += spacesAndMins.xSpace) {
            featureBuilder.reset();
            LinearCoordinateSequence coordinateSequence = LineGridStrategy.getLinearCoordinateSequence(layerData, numDimensions, bounds, x, pointSpacing, direction, 1);
            SimpleFeature feature = this.createFeature(featureBuilder, geometryFactory, ++i, 1, coordinateSequence);
            features.add(feature);
            Geometry intersectionsTB = GridUtils.computeTopBorderIntersections(rotatedBounds, geometryFactory, x);
            GridUtils.topBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsTB);
            Geometry intersectionsBB = GridUtils.computeBottomBorderIntersections(rotatedBounds, geometryFactory, x);
            GridUtils.bottomBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsBB);
        }
        pointSpacing = bounds.getSpan(0) / (double)layerData.pointsInLine;
        int j = 0;
        for (double y = spacesAndMins.minY; y < bounds.getMaxY(); y += spacesAndMins.ySpace) {
            featureBuilder.reset();
            LinearCoordinateSequence coordinateSequence = LineGridStrategy.getLinearCoordinateSequence(layerData, numDimensions, bounds, y, pointSpacing, direction, 0);
            SimpleFeature feature = this.createFeature(featureBuilder, geometryFactory, ++j, 0, coordinateSequence);
            features.add(feature);
            Geometry intersectionsRB = GridUtils.computeRightBorderIntersections(rotatedBounds, geometryFactory, y);
            GridUtils.rightBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsRB);
            Geometry intersectionsLB = GridUtils.computeLeftBorderIntersections(rotatedBounds, geometryFactory, y);
            GridUtils.leftBorderLabel(labels, unit, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat(), intersectionsLB);
        }
        return features;
    }

    private static LinearCoordinateSequence getLinearCoordinateSequence(GridParam layerData, int numDimensions, ReferencedEnvelope bounds, double pointCoordinate, double pointSpacing, AxisDirection direction, int variableAxis) {
        double originY;
        double originX;
        int numPoints = layerData.pointsInLine + 1;
        if (variableAxis == 0) {
            originX = bounds.getMinimum(0);
            originY = pointCoordinate;
        } else if (variableAxis == 1) {
            originX = pointCoordinate;
            originY = bounds.getMinimum(1);
        } else {
            throw new RuntimeException("Unsupported variableAxis =" + variableAxis);
        }
        return new LinearCoordinateSequence().setDimension(numDimensions).setOrigin(originX, originY).setVariableAxis(variableAxis).setNumPoints(numPoints).setSpacing(pointSpacing).setOrdinate0AxisDirection(direction);
    }

    private SimpleFeature createFeature(SimpleFeatureBuilder featureBuilder, GeometryFactory geometryFactory, int i, int ordinate, LinearCoordinateSequence coordinateSequence) {
        LineString geom = geometryFactory.createLineString((CoordinateSequence)coordinateSequence);
        featureBuilder.set("geom", (Object)geom);
        return featureBuilder.buildFeature("grid." + (ordinate == 1 ? (char)'x' : 'y') + "." + i);
    }

    private static final class SpacesAndMins {
        public final double xSpace;
        public final double ySpace;
        public final double minX;
        public final double minY;

        SpacesAndMins(double xSpace, double ySpace, double minX, double minY) {
            this.xSpace = xSpace;
            this.ySpace = ySpace;
            this.minX = minX;
            this.minY = minY;
        }
    }
}

