/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Stroke;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.AbstractStyleVisitor;
import org.mapfish.print.map.geotools.function.MultiplicationFunction;

public final class OpacitySettingStyleVisitor
extends AbstractStyleVisitor {
    private final Expression opacityFactor;
    private final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();

    public OpacitySettingStyleVisitor(double opacityFactor) {
        this.opacityFactor = this.filterFactory.literal(opacityFactor);
    }

    public void visit(Fill fill) {
        Expression opacity = fill.getOpacity();
        Function newExpr = this.getOpacityAdjustingExpression(opacity);
        fill.setOpacity((Expression)newExpr);
    }

    public void visit(Stroke stroke) {
        Expression opacity = stroke.getOpacity();
        Function newExpr = this.getOpacityAdjustingExpression(opacity);
        stroke.setOpacity((Expression)newExpr);
    }

    public void visit(Graphic gr) {
        Expression opacity = gr.getOpacity();
        Function newExpr = this.getOpacityAdjustingExpression(opacity);
        gr.setOpacity((Expression)newExpr);
    }

    public void visit(RasterSymbolizer raster) {
        Expression opacity = raster.getOpacity();
        Function newExpr = this.getOpacityAdjustingExpression(opacity);
        raster.setOpacity((Expression)newExpr);
    }

    private Function getOpacityAdjustingExpression(Expression opacity) {
        return this.filterFactory.function(MultiplicationFunction.NAME.getName(), new Expression[]{opacity, this.opacityFactor});
    }
}

