/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.ConfigurationObject;
import org.mapfish.print.config.ReportStorage;

public class SmtpConfig
implements ConfigurationObject {
    public static final String DEFAULT_SUBJECT = "MapFish print document";
    public static final String DEFAULT_BODY = "Please find attached the requested document";
    public static final String DEFAULT_BODY_STORAGE = "Please find the requested document there: {url}";
    public static final String DEFAULT_ERROR_SUBJECT = "MapFish print error";
    public static final String DEFAULT_ERROR_BODY = "The print job failed:<br>{message}";
    private String fromAddress;
    private String host;
    private int port = 25;
    private String username;
    private String password;
    private boolean starttls = false;
    private boolean ssl = false;
    private String subject = "MapFish print document";
    private String body = null;
    private String errorSubject = "MapFish print error";
    private String errorBody = "The print job failed:<br>{message}";
    private ReportStorage storage = null;

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.fromAddress == null) {
            validationErrors.add(new ConfigurationException("Missing fromAddress"));
        }
        if (this.host == null) {
            validationErrors.add(new ConfigurationException("Missing host"));
        }
        if (this.username == null ^ this.password == null) {
            validationErrors.add(new ConfigurationException("Missing username or password"));
        }
        if (this.ssl && this.starttls) {
            validationErrors.add(new ConfigurationException("Cannot enable ssl and starttls at the same time"));
        }
        if (this.storage != null) {
            this.storage.validate(validationErrors, configuration);
        }
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isStarttls() {
        return this.starttls;
    }

    public void setStarttls(boolean starttls) {
        this.starttls = starttls;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    @Nonnull
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(@Nonnull String subject) {
        this.subject = subject;
    }

    @Nonnull
    public String getBody() {
        if (this.body == null) {
            return this.storage == null ? DEFAULT_BODY : DEFAULT_BODY_STORAGE;
        }
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Nullable
    public ReportStorage getStorage() {
        return this.storage;
    }

    public void setStorage(ReportStorage storage) {
        this.storage = storage;
    }

    @Nonnull
    public String getErrorSubject() {
        return this.errorSubject;
    }

    public void setErrorSubject(@Nonnull String errorSubject) {
        this.errorSubject = errorSubject;
    }

    @Nonnull
    public String getErrorBody() {
        return this.errorBody;
    }

    public void setErrorBody(@Nonnull String errorBody) {
        this.errorBody = errorBody;
    }
}

