/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import java.awt.Rectangle;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.jts.geom.Coordinate;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.PrintException;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;

public final class CenterScaleMapBounds
extends MapBounds {
    private final Coordinate center;
    private final Scale scale;

    public CenterScaleMapBounds(CoordinateReferenceSystem projection, double centerX, double centerY, double scaleDenominator) {
        super(projection);
        this.center = new Coordinate(centerX, centerY);
        this.scale = new Scale(scaleDenominator, this.getProjection(), 72.0);
    }

    public CenterScaleMapBounds(CoordinateReferenceSystem projection, double centerX, double centerY, Scale scale) {
        super(projection);
        this.center = new Coordinate(centerX, centerY);
        this.scale = scale;
    }

    @Override
    public ReferencedEnvelope toReferencedEnvelope(Rectangle paintArea) {
        ReferencedEnvelope bbox;
        DistanceUnit projectionUnit = DistanceUnit.fromProjection(this.getProjection());
        if (projectionUnit == DistanceUnit.DEGREES) {
            double geoWidthInches = this.scale.getResolutionInInches() * (double)paintArea.width;
            double geoHeightInches = this.scale.getResolutionInInches() * (double)paintArea.height;
            bbox = this.computeGeodeticBBox(geoWidthInches, geoHeightInches);
        } else {
            double centerX = this.center.getOrdinate(0);
            double centerY = this.center.getOrdinate(1);
            double geoWidth = this.scale.getResolution() * (double)paintArea.width;
            double geoHeight = this.scale.getResolution() * (double)paintArea.height;
            double minGeoX = centerX - geoWidth / 2.0;
            double minGeoY = centerY - geoHeight / 2.0;
            double maxGeoX = minGeoX + geoWidth;
            double maxGeoY = minGeoY + geoHeight;
            bbox = new ReferencedEnvelope(minGeoX, maxGeoX, minGeoY, maxGeoY, this.getProjection());
        }
        return bbox;
    }

    @Override
    public MapBounds adjustedEnvelope(Rectangle paintArea) {
        return this;
    }

    @Override
    public MapBounds adjustBoundsToNearestScale(ZoomLevels zoomLevels, double tolerance, ZoomLevelSnapStrategy zoomLevelSnapStrategy, boolean geodetic, Rectangle paintArea, double dpi) {
        Scale newScale = this.getNearestScale(zoomLevels, tolerance, zoomLevelSnapStrategy, geodetic, paintArea, dpi);
        return new CenterScaleMapBounds(this.getProjection(), this.center.x, this.center.y, newScale);
    }

    @Override
    public Scale getScale(Rectangle paintArea, double dpi) {
        return this.scale;
    }

    @Override
    public MapBounds adjustBoundsToRotation(double rotation) {
        return this;
    }

    @Override
    public CenterScaleMapBounds zoomOut(double factor) {
        if (FloatingPointUtil.equals(factor, 1.0)) {
            return this;
        }
        double newResolution = this.scale.getResolution() * factor;
        return new CenterScaleMapBounds(this.getProjection(), this.center.x, this.center.y, this.scale.toResolution(newResolution));
    }

    @Override
    public MapBounds zoomToScale(Scale newScale) {
        return new CenterScaleMapBounds(this.getProjection(), this.center.x, this.center.y, newScale);
    }

    @Override
    public Coordinate getCenter() {
        return this.center;
    }

    private ReferencedEnvelope computeGeodeticBBox(double geoWidthInInches, double geoHeightInInches) {
        try {
            CoordinateReferenceSystem crs = this.getProjection();
            GeodeticCalculator calc = new GeodeticCalculator(crs);
            DistanceUnit ellipsoidUnit = DistanceUnit.fromString(calc.getEllipsoid().getAxisUnit().toString());
            double geoWidth = DistanceUnit.IN.convertTo(geoWidthInInches, ellipsoidUnit);
            double geoHeight = DistanceUnit.IN.convertTo(geoHeightInInches, ellipsoidUnit);
            Position2D directPosition2D = new Position2D(this.center.x, this.center.y);
            directPosition2D.setCoordinateReferenceSystem(crs);
            calc.setStartingPosition((Position)directPosition2D);
            int west = -90;
            calc.setDirection(-90.0, geoWidth / 2.0);
            double minGeoX = calc.getDestinationPosition().getOrdinate(0);
            int east = 90;
            calc.setDirection(90.0, geoWidth / 2.0);
            double maxGeoX = calc.getDestinationPosition().getOrdinate(0);
            int south = 180;
            calc.setDirection(180.0, geoHeight / 2.0);
            double minGeoY = calc.getDestinationPosition().getOrdinate(1);
            boolean north = false;
            calc.setDirection(0.0, geoHeight / 2.0);
            double maxGeoY = calc.getDestinationPosition().getOrdinate(1);
            return new ReferencedEnvelope(this.rollLongitude(minGeoX), this.rollLongitude(maxGeoX), this.rollLatitude(minGeoY), this.rollLatitude(maxGeoY), crs);
        }
        catch (TransformException e) {
            throw new PrintException("Failed to compute geodetic bbox", e);
        }
    }

    private double rollLongitude(double x) {
        return x - (double)((int)(x + Math.signum(x) * 180.0) / 360) * 360.0;
    }

    private double rollLatitude(double y) {
        return y - (double)((int)(y + Math.signum(y) * 90.0) / 180) * 180.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CenterScaleMapBounds that = (CenterScaleMapBounds)o;
        if (this.center != null ? !this.center.equals((Object)that.center) : that.center != null) {
            return false;
        }
        return this.scale != null ? this.scale.equals(that.scale) : that.scale == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.center != null ? this.center.hashCode() : 0);
        result = 31 * result + (this.scale != null ? this.scale.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("CenterScaleMapBounds{center=%s, scale=%s}", this.center, this.scale);
    }
}

