/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import java.awt.image.BufferedImage;
import java.net.URI;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;

public final class SvgUtil {
    private SvgUtil() {
    }

    public static BufferedImage convertFromSvg(URI svgFile, int width, int height) throws TranscoderException {
        BufferedImageTranscoder imageTranscoder = new BufferedImageTranscoder();
        imageTranscoder.addTranscodingHint(TIFFTranscoder.KEY_WIDTH, Float.valueOf(width));
        imageTranscoder.addTranscodingHint(TIFFTranscoder.KEY_HEIGHT, Float.valueOf(height));
        TranscoderInput input = new TranscoderInput(svgFile.toString());
        imageTranscoder.transcode(input, null);
        return imageTranscoder.getBufferedImage();
    }

    private static class BufferedImageTranscoder
    extends ImageTranscoder {
        private BufferedImage img = null;

        private BufferedImageTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            BufferedImage bi = new BufferedImage(w, h, 2);
            return bi;
        }

        public void writeImage(BufferedImage image, TranscoderOutput output) {
            this.img = image;
        }

        public BufferedImage getBufferedImage() {
            return this.img;
        }
    }
}

