/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.spark.typify.spec;

import com.google.gson.FieldAttributes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class IgnoreSpec {
    private List<Class<? extends Annotation>> ignoreAnnotated;
    private List<Class<?>> ignoreTypes;
    private List<String> endpointPaths;

    public List<Class<? extends Annotation>> getIgnoreAnnotated() {
        return this.ignoreAnnotated;
    }

    public void setIgnoreAnnotated(List<Class<? extends Annotation>> ignoreAnnotated) {
        this.ignoreAnnotated = ignoreAnnotated;
    }

    public List<Class<?>> getIgnoreTypes() {
        return this.ignoreTypes;
    }

    public void setIgnoreTypes(List<Class<?>> ignoreTypes) {
        this.ignoreTypes = ignoreTypes;
    }

    public List<String> getEndpointPaths() {
        return this.endpointPaths;
    }

    public void setEndpointPaths(List<String> endpointPaths) {
        this.endpointPaths = endpointPaths;
    }

    public boolean ignored(String path) {
        return this.endpointPaths != null && this.endpointPaths.contains(path);
    }

    public boolean ignored(Field field) {
        if (this.ignoreTypes != null) {
            Type type;
            if ((field.getType().isArray() || Collection.class.isAssignableFrom(field.getType())) && (type = field.getGenericType()) instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                for (Type paramType : pt.getActualTypeArguments()) {
                    if (!this.ignoreTypes.stream().map(Class::getTypeName).anyMatch(typeName -> typeName.equalsIgnoreCase(paramType.getTypeName()))) continue;
                    return true;
                }
            }
            return this.ignoreTypes.contains(field.getType());
        }
        return false;
    }

    public boolean ignored(FieldAttributes field) {
        if (this.ignoreTypes != null) {
            Type type;
            if ((field.getDeclaredClass().isArray() || Collection.class.isAssignableFrom(field.getDeclaredClass())) && (type = field.getDeclaredType()) instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                for (Type paramType : pt.getActualTypeArguments()) {
                    if (!this.ignoreTypes.stream().map(Class::getTypeName).anyMatch(typeName -> typeName.equalsIgnoreCase(paramType.getTypeName()))) continue;
                    return true;
                }
            }
            return this.ignoreTypes.contains(field.getDeclaredClass());
        }
        return false;
    }

    public boolean ignoreAnnotated(Class<?> type) {
        if (this.ignoreAnnotated != null) {
            for (Class<? extends Annotation> annotationType : this.ignoreAnnotated) {
                if (!type.isAnnotationPresent(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ignoreAnnotated(Field field) {
        if (this.ignoreAnnotated != null) {
            for (Class<? extends Annotation> annotationType : this.ignoreAnnotated) {
                if (field.getAnnotation(annotationType) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ignoreAnnotated(FieldAttributes field) {
        if (this.ignoreAnnotated != null) {
            for (Class<? extends Annotation> annotationType : this.ignoreAnnotated) {
                if (field.getAnnotation(annotationType) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Class<? extends Annotation>> ignoreAnnotated;
        private List<Class<?>> ignoreTypes;
        private List<String> endpointPaths;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withIgnoreAnnotated(Class<? extends Annotation> ... ignoreAnnotated) {
            this.ignoreAnnotated = Arrays.asList(ignoreAnnotated);
            return this;
        }

        public Builder withIgnoreTypes(Class<?> ... ignoreTypes) {
            this.ignoreTypes = Arrays.asList(ignoreTypes);
            return this;
        }

        public Builder withEndpointPaths(String ... endpointPaths) {
            this.endpointPaths = Arrays.asList(endpointPaths);
            return this;
        }

        public IgnoreSpec build() {
            IgnoreSpec ignoreSpec = new IgnoreSpec();
            ignoreSpec.setIgnoreAnnotated(this.ignoreAnnotated);
            ignoreSpec.setIgnoreTypes(this.ignoreTypes);
            ignoreSpec.setEndpointPaths(this.endpointPaths);
            return ignoreSpec;
        }
    }
}

