/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.spark.typify.route;

import io.github.manusant.spark.typify.annotation.Json;
import io.github.manusant.spark.typify.annotation.Xml;
import io.github.manusant.spark.typify.exception.ReflectionExceptions;
import io.github.manusant.spark.typify.provider.TypifyProvider;
import io.github.manusant.spark.typify.spec.ContentType;
import java.lang.reflect.Method;
import spark.Request;
import spark.Response;

public abstract class Route
implements spark.Route {
    public abstract Object onRequest(Request var1, Response var2);

    public Object handle(Request request, Response response) {
        Object result = this.onRequest(request, response);
        try {
            if (result != null) {
                Method m = this.getClass().getMethod("onRequest", Request.class, Response.class);
                Json json = m.getAnnotation(Json.class);
                Xml xml = m.getAnnotation(Xml.class);
                if (json != null) {
                    response.type(ContentType.APPLICATION_JSON.getValue());
                    return TypifyProvider.gson().toJson(result);
                }
                if (xml != null) {
                    response.type(ContentType.APPLICATION_XML.getValue());
                    throw new UnsupportedOperationException("XML mapping not supported yet");
                }
                response.type(ContentType.APPLICATION_JSON.getValue());
                return TypifyProvider.gson().toJson(result);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            ReflectionExceptions.handleReflectionException(e);
        }
        return null;
    }
}

