/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.spark.typify.provider;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.manusant.spark.typify.spec.IgnoreSpec;
import java.util.function.Supplier;

public class TypifyProvider {
    private static Gson GSON;

    private static Gson create(final IgnoreSpec ignoreSpec) {
        GSON = new GsonBuilder().setPrettyPrinting().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return ignoreSpec != null && (ignoreSpec.ignoreAnnotated(fieldAttributes) || ignoreSpec.ignored(fieldAttributes));
            }

            public boolean shouldSkipClass(Class<?> aClass) {
                return false;
            }
        }}).create();
        return GSON;
    }

    public static void setUp(Supplier<IgnoreSpec> ignoreSupplier) {
        TypifyProvider.create(ignoreSupplier.get());
    }

    public static void setUp(IgnoreSpec ignore) {
        TypifyProvider.create(ignore);
    }

    public static Gson gson() {
        if (GSON == null) {
            TypifyProvider.create(null);
        }
        return GSON;
    }
}

