/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SpecialBarFontUtils {
    private static Method mSetStatusBarColorIcon;
    private static Method mSetStatusBarDarkIcon;
    private static Field mStatusBarColorFiled;
    private static int SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;

    static boolean isBlackColor(int color2, int level) {
        int grey = SpecialBarFontUtils.toGrey(color2);
        return grey < level;
    }

    static int toGrey(int rgb) {
        int blue = rgb & 0xFF;
        int green = (rgb & 0xFF00) >> 8;
        int red = (rgb & 0xFF0000) >> 16;
        return red * 38 + green * 75 + blue * 15 >> 7;
    }

    public static void setStatusBarDarkIcon(Activity activity, int color2) {
        if (mSetStatusBarColorIcon != null) {
            try {
                mSetStatusBarColorIcon.invoke((Object)activity, color2);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            boolean whiteColor = SpecialBarFontUtils.isBlackColor(color2, 50);
            if (mStatusBarColorFiled != null) {
                SpecialBarFontUtils.setStatusBarDarkIcon(activity, whiteColor, whiteColor);
                SpecialBarFontUtils.setStatusBarDarkIcon(activity.getWindow(), color2);
            } else {
                SpecialBarFontUtils.setStatusBarDarkIcon(activity, whiteColor);
            }
        }
    }

    public static void setStatusBarDarkIcon(Window window, int color2) {
        try {
            SpecialBarFontUtils.setStatusBarColor(window, color2);
            if (Build.VERSION.SDK_INT > 22) {
                SpecialBarFontUtils.setStatusBarDarkIcon(window.getDecorView(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setStatusBarDarkIcon(Activity activity, boolean dark) {
        SpecialBarFontUtils.setStatusBarDarkIcon(activity, dark, true);
    }

    private static boolean changeMeizuFlag(WindowManager.LayoutParams winParams, String flagName, boolean on) {
        try {
            int meizuFlags;
            Field f = winParams.getClass().getDeclaredField(flagName);
            f.setAccessible(true);
            int bits = f.getInt(winParams);
            Field f2 = winParams.getClass().getDeclaredField("meizuFlags");
            f2.setAccessible(true);
            int oldFlags = meizuFlags = f2.getInt(winParams);
            meizuFlags = on ? (meizuFlags |= bits) : (meizuFlags &= ~bits);
            if (oldFlags != meizuFlags) {
                f2.setInt(winParams, meizuFlags);
                return true;
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    private static void setStatusBarDarkIcon(View view, boolean dark) {
        int oldVis;
        int newVis = oldVis = view.getSystemUiVisibility();
        newVis = dark ? (newVis |= SYSTEM_UI_FLAG_LIGHT_STATUS_BAR) : (newVis &= ~SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
        if (newVis != oldVis) {
            view.setSystemUiVisibility(newVis);
        }
    }

    private static void setStatusBarColor(Window window, int color2) {
        WindowManager.LayoutParams winParams = window.getAttributes();
        if (mStatusBarColorFiled != null) {
            try {
                int oldColor = mStatusBarColorFiled.getInt(winParams);
                if (oldColor != color2) {
                    mStatusBarColorFiled.set(winParams, color2);
                    window.setAttributes(winParams);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setStatusBarDarkIcon(Window window, boolean dark) {
        if (Build.VERSION.SDK_INT < 23) {
            SpecialBarFontUtils.changeMeizuFlag(window.getAttributes(), "MEIZU_FLAG_DARK_STATUS_BAR_ICON", dark);
        } else {
            View decorView = window.getDecorView();
            SpecialBarFontUtils.setStatusBarDarkIcon(decorView, dark);
            SpecialBarFontUtils.setStatusBarColor(window, 0);
        }
    }

    private static void setStatusBarDarkIcon(Activity activity, boolean dark, boolean flag) {
        if (mSetStatusBarDarkIcon != null) {
            try {
                mSetStatusBarDarkIcon.invoke((Object)activity, dark);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (flag) {
            SpecialBarFontUtils.setStatusBarDarkIcon(activity.getWindow(), dark);
        }
    }

    @SuppressLint(value={"PrivateApi"})
    static void setMIUIBarDark(Window window, String key, boolean dark) {
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField(key);
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (dark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        SYSTEM_UI_FLAG_LIGHT_STATUS_BAR = 0;
        try {
            mSetStatusBarColorIcon = Activity.class.getMethod("setStatusBarDarkIcon", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            mSetStatusBarDarkIcon = Activity.class.getMethod("setStatusBarDarkIcon", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            mStatusBarColorFiled = WindowManager.LayoutParams.class.getField("statusBarColor");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        try {
            Field field = View.class.getField("SYSTEM_UI_FLAG_LIGHT_STATUS_BAR");
            SYSTEM_UI_FLAG_LIGHT_STATUS_BAR = field.getInt(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

