/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.app.Application;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.maning.mndialoglibrary.R;
import com.maning.mndialoglibrary.config.MToastConfig;
import com.maning.mndialoglibrary.utils.MSizeUtils;
import java.lang.reflect.InvocationTargetException;

public class MToast {
    private static Handler UIHandler = new Handler(Looper.getMainLooper());
    private static Toast currentToast;
    private static Context mAppContext;

    public static void init(Context context) {
        mAppContext = context.getApplicationContext();
    }

    public static void makeTextLong(@NonNull Context context, @NonNull CharSequence message, MToastConfig config) {
        MToast.show(config, context, message, 1);
    }

    public static void makeTextShort(@NonNull Context context, @NonNull CharSequence message, MToastConfig config) {
        MToast.show(config, context, message, 0);
    }

    public static void makeTextLong(@NonNull Context context, @NonNull CharSequence message) {
        MToast.show(null, context, message, 1);
    }

    public static void makeTextShort(@NonNull Context context, @NonNull CharSequence message) {
        MToast.show(null, context, message, 0);
    }

    public static void makeTextLong(@NonNull CharSequence message) {
        MToast.show(null, mAppContext, message, 1);
    }

    public static void makeTextShort(@NonNull CharSequence message) {
        MToast.show(null, mAppContext, message, 0);
    }

    private static void show(final MToastConfig config, Context context, final CharSequence message, final int duration) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        try {
            if (mAppContext == null) {
                mAppContext = context != null ? context.getApplicationContext() : MToast.getApplicationByReflect().getApplicationContext();
            }
            if (mAppContext == null) {
                return;
            }
            if (Looper.getMainLooper() == Looper.myLooper()) {
                MToast.getToast(config, mAppContext, message, duration).show();
            } else {
                UIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        MToast.getToast(config, mAppContext, message, duration).show();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)">>>MToast>>>", (String)("MToast\u5f02\u5e38\uff1a" + e.toString()));
        }
    }

    private static Toast getToast(MToastConfig config, Context context, CharSequence message, int duration) {
        MToast.cancelToast();
        Context mCotext = context.getApplicationContext();
        if (currentToast == null) {
            currentToast = new Toast(mCotext);
        }
        View toastLayout = ((LayoutInflater)mCotext.getSystemService("layout_inflater")).inflate(R.layout.mn_toast_layout, null);
        TextView tvShowToast = (TextView)toastLayout.findViewById(R.id.tvShowToast);
        ImageView ivLeftShow = (ImageView)toastLayout.findViewById(R.id.ivLeftShow);
        LinearLayout toastBackgroundView = (LinearLayout)toastLayout.findViewById(R.id.toastBackgroundView);
        currentToast.setView(toastLayout);
        if (config == null) {
            config = new MToastConfig.Builder().build();
        }
        MToastConfig.MToastGravity toastGravity = config.toastGravity;
        int toastTextColor = config.toastTextColor;
        float toastTextSize = config.toastTextSize;
        int toastBackgroundColor = config.toastBackgroundColor;
        float toastBackgroundCornerRadius = config.toastBackgroundCornerRadius;
        Drawable toastIcon = config.toastIcon;
        int toastBackgroundStrokeColor = config.toastBackgroundStrokeColor;
        float toastBackgroundStrokeWidth = config.toastBackgroundStrokeWidth;
        if (toastIcon == null) {
            ivLeftShow.setVisibility(8);
        } else {
            ivLeftShow.setVisibility(0);
            ivLeftShow.setImageDrawable(toastIcon);
        }
        tvShowToast.setTextColor(toastTextColor);
        tvShowToast.setTextSize(2, toastTextSize);
        tvShowToast.setText(message);
        GradientDrawable myGrad = new GradientDrawable();
        myGrad.setCornerRadius((float)MSizeUtils.dp2px(mCotext, toastBackgroundCornerRadius));
        myGrad.setColor(toastBackgroundColor);
        myGrad.setStroke(MSizeUtils.dp2px(mCotext, toastBackgroundStrokeWidth), toastBackgroundStrokeColor);
        if (Build.VERSION.SDK_INT >= 16) {
            toastBackgroundView.setBackground((Drawable)myGrad);
        } else {
            toastBackgroundView.setBackgroundDrawable((Drawable)myGrad);
        }
        toastBackgroundView.setPadding(MSizeUtils.dp2px(mCotext, config.paddingLeft), MSizeUtils.dp2px(mCotext, config.paddingTop), MSizeUtils.dp2px(mCotext, config.paddingRight), MSizeUtils.dp2px(mCotext, config.paddingBottom));
        if (toastGravity == MToastConfig.MToastGravity.CENTRE) {
            currentToast.setGravity(17, 0, 0);
        } else {
            currentToast.setGravity(80, 0, MSizeUtils.dp2px(mCotext, 80.0f));
        }
        if (config.imgWidth > 0 && config.imgHeight > 0) {
            ViewGroup.LayoutParams layoutParams = ivLeftShow.getLayoutParams();
            layoutParams.width = MSizeUtils.dp2px(mCotext, config.imgWidth);
            layoutParams.height = MSizeUtils.dp2px(mCotext, config.imgHeight);
            ivLeftShow.setLayoutParams(layoutParams);
        }
        currentToast.setDuration(duration);
        return currentToast;
    }

    public static void cancelToast() {
        if (currentToast != null) {
            currentToast.cancel();
            currentToast = null;
        }
    }

    private static Application getApplicationByReflect() {
        try {
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            Object thread = activityThread.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Object app = activityThread.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                throw new NullPointerException("u should init first");
            }
            return (Application)app;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("u should init first");
    }
}

