/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary.utils;

import android.os.Build;
import android.support.v4.graphics.ColorUtils;
import android.view.View;
import android.view.Window;
import com.maning.mndialoglibrary.utils.OSUtils;
import com.maning.mndialoglibrary.utils.SpecialBarFontUtils;

public class StatusBarUtils {
    static final String IMMERSION_MIUI_STATUS_BAR_DARK = "EXTRA_FLAG_STATUS_BAR_DARK_MODE";

    private static boolean isSupportStatusBarDarkFont() {
        return OSUtils.isMIUI6Later() || OSUtils.isFlymeOS4Later() || Build.VERSION.SDK_INT >= 23;
    }

    private static void setStatusBarModeMIUI(Window window, boolean bDark) {
        if (OSUtils.isMIUI6Later()) {
            SpecialBarFontUtils.setMIUIBarDark(window, IMMERSION_MIUI_STATUS_BAR_DARK, bDark);
        }
    }

    private static void setStatusBarModeFlyme(Window window, boolean bDark) {
        if (OSUtils.isFlymeOS4Later()) {
            SpecialBarFontUtils.setStatusBarDarkIcon(window, bDark);
        }
    }

    private static void setStatusBarModeDefault(Window window, boolean bDark) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (window == null) {
                return;
            }
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(ColorUtils.blendARGB((int)0, (int)-16777216, (float)0.0f));
            View decorView = window.getDecorView();
            if (decorView != null) {
                int vis = decorView.getSystemUiVisibility();
                vis |= 0x100;
                vis = bDark ? (vis |= 0x2000) : (vis &= 0xFFFFDFFF);
                decorView.setSystemUiVisibility(vis);
            }
        }
    }

    public static void setStatusBarMode(Window window, boolean bDark) {
        if (StatusBarUtils.isSupportStatusBarDarkFont()) {
            StatusBarUtils.setStatusBarModeDefault(window, bDark);
            StatusBarUtils.setStatusBarModeMIUI(window, bDark);
            StatusBarUtils.setStatusBarModeFlyme(window, bDark);
        }
    }
}

