/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary.config;

import android.graphics.Color;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.maning.mndialoglibrary.listeners.OnDialogDismissListener;

public class MDialogConfig {
    public boolean windowFullscreen = false;
    public boolean canceledOnTouchOutside = false;
    public boolean cancelable = false;
    public int backgroundWindowColor = 0;
    public int backgroundViewColor = Color.parseColor((String)"#b2000000");
    public int strokeColor = 0;
    public float cornerRadius = 8.0f;
    public float strokeWidth = 0.0f;
    public int progressColor = -1;
    public float progressWidth = 2.0f;
    public float progressSize = 45.0f;
    public int progressRimColor = 0;
    public int progressRimWidth = 0;
    public int textColor = -1;
    public float textSize = 12.0f;
    public OnDialogDismissListener onDialogDismissListener;
    public int animationID = 0;
    public int paddingLeft = 12;
    public int paddingTop = 12;
    public int paddingRight = 12;
    public int paddingBottom = 12;
    public int imgWidth = 40;
    public int imgHeight = 40;

    private MDialogConfig() {
    }

    public static class Builder {
        private MDialogConfig mDialogConfig = new MDialogConfig();

        public MDialogConfig build() {
            return this.mDialogConfig;
        }

        public Builder isCanceledOnTouchOutside(@Nullable boolean canceledOnTouchOutside) {
            this.mDialogConfig.canceledOnTouchOutside = canceledOnTouchOutside;
            return this;
        }

        public Builder isWindowFullscreen(@Nullable boolean windowFullscreen) {
            this.mDialogConfig.windowFullscreen = windowFullscreen;
            return this;
        }

        public Builder isCancelable(@Nullable boolean cancelable) {
            this.mDialogConfig.cancelable = cancelable;
            return this;
        }

        public Builder setBackgroundWindowColor(@Nullable int backgroundWindowColor) {
            this.mDialogConfig.backgroundWindowColor = backgroundWindowColor;
            return this;
        }

        public Builder setBackgroundViewColor(@Nullable int backgroundViewColor) {
            this.mDialogConfig.backgroundViewColor = backgroundViewColor;
            return this;
        }

        public Builder setStrokeColor(@Nullable int strokeColor) {
            this.mDialogConfig.strokeColor = strokeColor;
            return this;
        }

        public Builder setStrokeWidth(@Nullable float strokeWidth) {
            this.mDialogConfig.strokeWidth = strokeWidth;
            return this;
        }

        public Builder setCornerRadius(@Nullable float cornerRadius) {
            this.mDialogConfig.cornerRadius = cornerRadius;
            return this;
        }

        public Builder setProgressColor(@Nullable int progressColor) {
            this.mDialogConfig.progressColor = progressColor;
            return this;
        }

        public Builder setProgressWidth(@Nullable float progressWidth) {
            this.mDialogConfig.progressWidth = progressWidth;
            return this;
        }

        public Builder setProgressRimColor(int progressRimColor) {
            this.mDialogConfig.progressRimColor = progressRimColor;
            return this;
        }

        public Builder setProgressRimWidth(int progressRimWidth) {
            this.mDialogConfig.progressRimWidth = progressRimWidth;
            return this;
        }

        public Builder setProgressSize(int progressSize) {
            this.mDialogConfig.progressSize = progressSize;
            return this;
        }

        public Builder setTextColor(@Nullable int textColor) {
            this.mDialogConfig.textColor = textColor;
            return this;
        }

        public Builder setTextSize(float textSize) {
            this.mDialogConfig.textSize = textSize;
            return this;
        }

        public Builder setOnDialogDismissListener(OnDialogDismissListener onDialogDismissListener) {
            this.mDialogConfig.onDialogDismissListener = onDialogDismissListener;
            return this;
        }

        public Builder setAnimationID(@StyleRes int resId) {
            this.mDialogConfig.animationID = resId;
            return this;
        }

        public Builder setImgWidthAndHeight(int imgWidth, int imgHeight) {
            this.mDialogConfig.imgWidth = imgWidth;
            this.mDialogConfig.imgHeight = imgHeight;
            return this;
        }

        public Builder setPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
            this.mDialogConfig.paddingLeft = paddingLeft;
            this.mDialogConfig.paddingTop = paddingTop;
            this.mDialogConfig.paddingRight = paddingRight;
            this.mDialogConfig.paddingBottom = paddingBottom;
            return this;
        }
    }
}

