/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.maning.mndialoglibrary.R;
import com.maning.mndialoglibrary.config.MDialogConfig;
import com.maning.mndialoglibrary.utils.MSizeUtils;

public class MStatusDialog {
    private Handler mHandler;
    private Context mContext;
    private Dialog mDialog;
    private MDialogConfig mDialogConfig;
    private RelativeLayout dialog_window_background;
    private RelativeLayout dialog_view_bg;
    private ImageView imageStatus;
    private TextView tvShow;

    public MStatusDialog(Context context) {
        this(context, new MDialogConfig.Builder().build());
    }

    public MStatusDialog(Context context, MDialogConfig dialogConfig) {
        this.mContext = context;
        this.mDialogConfig = dialogConfig;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.initDialog();
    }

    private void initDialog() {
        try {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            View mProgressDialogView = inflater.inflate(R.layout.mn_status_dialog_layout, null);
            this.mDialog = new Dialog(this.mContext, R.style.MNCustomDialog);
            this.mDialog.setCancelable(false);
            this.mDialog.setCanceledOnTouchOutside(false);
            this.mDialog.setContentView(mProgressDialogView);
            WindowManager.LayoutParams layoutParams = this.mDialog.getWindow().getAttributes();
            layoutParams.width = -1;
            layoutParams.height = -1;
            layoutParams.gravity = 17;
            this.mDialog.getWindow().setAttributes(layoutParams);
            this.dialog_window_background = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_window_background);
            this.dialog_view_bg = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_view_bg);
            this.imageStatus = (ImageView)mProgressDialogView.findViewById(R.id.imageStatus);
            this.tvShow = (TextView)mProgressDialogView.findViewById(R.id.tvShow);
            this.configView();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkDialogConfig() {
        if (this.mDialogConfig == null) {
            this.mDialogConfig = new MDialogConfig.Builder().build();
        }
    }

    private void configView() {
        this.checkDialogConfig();
        this.dialog_window_background.setBackgroundColor(this.mDialogConfig.backgroundWindowColor);
        this.tvShow.setTextColor(this.mDialogConfig.textColor);
        this.tvShow.setTextSize(this.mDialogConfig.textSize);
        GradientDrawable myGrad = new GradientDrawable();
        myGrad.setColor(this.mDialogConfig.backgroundViewColor);
        myGrad.setStroke(MSizeUtils.dp2px(this.mContext, this.mDialogConfig.strokeWidth), this.mDialogConfig.strokeColor);
        myGrad.setCornerRadius((float)MSizeUtils.dp2px(this.mContext, this.mDialogConfig.cornerRadius));
        if (Build.VERSION.SDK_INT >= 16) {
            this.dialog_view_bg.setBackground((Drawable)myGrad);
        } else {
            this.dialog_view_bg.setBackgroundDrawable((Drawable)myGrad);
        }
        this.dialog_view_bg.setPadding(MSizeUtils.dp2px(this.mContext, this.mDialogConfig.paddingLeft), MSizeUtils.dp2px(this.mContext, this.mDialogConfig.paddingTop), MSizeUtils.dp2px(this.mContext, this.mDialogConfig.paddingRight), MSizeUtils.dp2px(this.mContext, this.mDialogConfig.paddingBottom));
        try {
            if (this.mDialogConfig != null && this.mDialogConfig.animationID != 0 && this.mDialog.getWindow() != null) {
                this.mDialog.getWindow().setWindowAnimations(this.mDialogConfig.animationID);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mDialogConfig.imgWidth > 0 && this.mDialogConfig.imgHeight > 0) {
            ViewGroup.LayoutParams layoutParams = this.imageStatus.getLayoutParams();
            layoutParams.width = MSizeUtils.dp2px(this.mContext, this.mDialogConfig.imgWidth);
            layoutParams.height = MSizeUtils.dp2px(this.mContext, this.mDialogConfig.imgHeight);
            this.imageStatus.setLayoutParams(layoutParams);
        }
        if (this.mDialogConfig.windowFullscreen) {
            this.mDialog.getWindow().setFlags(1024, 1024);
        }
    }

    public void show(String msg, Drawable drawable) {
        this.show(msg, drawable, 2000L);
    }

    public void show(String msg, Drawable drawable, long delayMillis) {
        try {
            if (this.mDialog == null) {
                return;
            }
            this.imageStatus.setImageDrawable(drawable);
            this.tvShow.setText((CharSequence)msg);
            this.mDialog.show();
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MStatusDialog.this.dismiss();
                }
            }, delayMillis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        try {
            this.mContext = null;
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler = null;
            }
            if (this.mDialog != null) {
                this.mDialog.dismiss();
                this.mDialog = null;
            }
            if (this.mDialogConfig != null && this.mDialogConfig.onDialogDismissListener != null) {
                this.mDialogConfig.onDialogDismissListener.onDismiss();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

