/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary.config;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;

public class MToastConfig {
    public int ToastTextColor = Color.parseColor((String)"#FFFFFFFF");
    public int ToastBackgroundColor = Color.parseColor((String)"#b2000000");
    public float ToastBackgroundCornerRadius = 6.0f;
    public float ToastBackgroundStrokeWidth = 0.0f;
    public int ToastBackgroundStrokeColor = Color.parseColor((String)"#00000000");
    public MToastGravity ToastGravity = MToastGravity.BOTTOM;
    public Drawable ToastIcon = null;

    private MToastConfig() {
    }

    public static class Builder {
        private MToastConfig mToastConfig = new MToastConfig();

        public MToastConfig build() {
            return this.mToastConfig;
        }

        public Builder setTextColor(@ColorInt int textColor) {
            this.mToastConfig.ToastTextColor = textColor;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int backgroundColor) {
            this.mToastConfig.ToastBackgroundColor = backgroundColor;
            return this;
        }

        public Builder setBackgroundCornerRadius(float radius) {
            this.mToastConfig.ToastBackgroundCornerRadius = radius;
            return this;
        }

        public Builder setGravity(MToastGravity toastGravity) {
            this.mToastConfig.ToastGravity = toastGravity;
            return this;
        }

        public Builder setToastIcon(Drawable ToastIcon) {
            this.mToastConfig.ToastIcon = ToastIcon;
            return this;
        }

        public Builder setBackgroundStrokeWidth(float width) {
            this.mToastConfig.ToastBackgroundStrokeWidth = width;
            return this;
        }

        public Builder setBackgroundStrokeColor(@ColorInt int strokeColor) {
            this.mToastConfig.ToastBackgroundStrokeColor = strokeColor;
            return this;
        }
    }

    public static enum MToastGravity {
        CENTRE,
        BOTTOM;

    }
}

