/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.maning.mndialoglibrary.R;
import com.maning.mndialoglibrary.config.MDialogConfig;
import com.maning.mndialoglibrary.utils.MSizeUtils;
import com.maning.mndialoglibrary.view.MProgressWheel;

public class MProgressDialog {
    private static Dialog mDialog;
    private static MDialogConfig mDialogConfig;
    private static RelativeLayout dialog_window_background;
    private static RelativeLayout dialog_view_bg;
    private static MProgressWheel progress_wheel;
    private static TextView tv_show;

    private static void initDialog(Context mContext) {
        LayoutInflater inflater = LayoutInflater.from((Context)mContext);
        View mProgressDialogView = inflater.inflate(R.layout.mn_progress_dialog_layout, null);
        mDialog = new Dialog(mContext, R.style.MNCustomDialog);
        mDialog.setCancelable(false);
        mDialog.setCanceledOnTouchOutside(false);
        mDialog.setContentView(mProgressDialogView);
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = ((Activity)mContext).getWindowManager();
        windowManager.getDefaultDisplay().getMetrics(dm);
        int screenW = dm.widthPixels;
        int screenH = dm.heightPixels;
        WindowManager.LayoutParams layoutParams = mDialog.getWindow().getAttributes();
        layoutParams.width = screenW;
        layoutParams.height = screenH;
        mDialog.getWindow().setAttributes(layoutParams);
        dialog_window_background = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_window_background);
        dialog_view_bg = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_view_bg);
        progress_wheel = (MProgressWheel)mProgressDialogView.findViewById(R.id.progress_wheel);
        tv_show = (TextView)mProgressDialogView.findViewById(R.id.tv_show);
        progress_wheel.spin();
        MProgressDialog.configView(mContext);
        dialog_window_background.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (mDialogConfig != null && mDialogConfig.canceledOnTouchOutside) {
                    MProgressDialog.dismissProgress();
                }
            }
        });
    }

    private static void configView(Context mContext) {
        if (MProgressDialog.mDialogConfig.animationID != 0 && mDialog.getWindow() != null) {
            mDialog.getWindow().setWindowAnimations(MProgressDialog.mDialogConfig.animationID);
        }
        mDialog.setCanceledOnTouchOutside(MProgressDialog.mDialogConfig.canceledOnTouchOutside);
        dialog_window_background.setBackgroundColor(MProgressDialog.mDialogConfig.backgroundWindowColor);
        GradientDrawable myGrad = new GradientDrawable();
        myGrad.setColor(MProgressDialog.mDialogConfig.backgroundViewColor);
        myGrad.setStroke(MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.strokeWidth), MProgressDialog.mDialogConfig.strokeColor);
        myGrad.setCornerRadius((float)MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.cornerRadius));
        dialog_view_bg.setBackground((Drawable)myGrad);
        progress_wheel.setBarColor(MProgressDialog.mDialogConfig.progressColor);
        progress_wheel.setBarWidth(MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.progressWidth));
        progress_wheel.setRimColor(MProgressDialog.mDialogConfig.progressRimColor);
        progress_wheel.setRimWidth(MProgressDialog.mDialogConfig.progressRimWidth);
        tv_show.setTextColor(MProgressDialog.mDialogConfig.textColor);
    }

    public static void showProgress(Context context) {
        MProgressDialog.showProgress(context, "\u52a0\u8f7d\u4e2d");
    }

    public static void showProgress(Context context, String msg) {
        MProgressDialog.showProgress(context, msg, null);
    }

    public static void showProgress(Context context, MDialogConfig mDialogConfig) {
        MProgressDialog.showProgress(context, "\u52a0\u8f7d\u4e2d", mDialogConfig);
    }

    public static void showProgress(Context context, String msg, MDialogConfig mDialogConfig) {
        if (mDialogConfig == null) {
            mDialogConfig = new MDialogConfig.Builder().build();
        }
        MProgressDialog.mDialogConfig = mDialogConfig;
        MProgressDialog.dismissProgress();
        MProgressDialog.initDialog(context);
        if (mDialog != null && tv_show != null) {
            if (TextUtils.isEmpty((CharSequence)msg)) {
                tv_show.setVisibility(8);
            } else {
                tv_show.setVisibility(0);
                tv_show.setText((CharSequence)msg);
            }
            mDialog.show();
        }
    }

    public static void dismissProgress() {
        if (mDialog != null && mDialog.isShowing()) {
            mDialog.dismiss();
            if (MProgressDialog.mDialogConfig.onDialogDismissListener != null) {
                MProgressDialog.mDialogConfig.onDialogDismissListener.onDismiss();
            }
            mDialog = null;
            mDialogConfig = null;
            dialog_window_background = null;
            dialog_view_bg = null;
            progress_wheel = null;
            tv_show = null;
        }
    }

    public static boolean isShowing() {
        if (mDialog != null) {
            return mDialog.isShowing();
        }
        return false;
    }
}

