/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.maning.mndialoglibrary.MToastConfig;
import com.maning.mndialoglibrary.R;

public class MToast {
    private static Toast currentToast;
    private static TextView tvShowToast;
    private static ImageView ivLeftShow;
    private static LinearLayout toastBackgroundView;

    public static Toast makeTextLong(@NonNull Context context, @NonNull CharSequence message, MToastConfig config) {
        return MToast.make(config, context, message, 1);
    }

    public static Toast makeTextShort(@NonNull Context context, @NonNull CharSequence message, MToastConfig config) {
        return MToast.make(config, context, message, 0);
    }

    public static Toast makeTextLong(@NonNull Context context, @NonNull CharSequence message) {
        return MToast.make(null, context, message, 1);
    }

    public static Toast makeTextShort(@NonNull Context context, @NonNull CharSequence message) {
        return MToast.make(null, context, message, 0);
    }

    private static Toast makeText(MToastConfig config, @NonNull Context context, @NonNull CharSequence message, int duration) {
        return MToast.make(config, context, message, duration);
    }

    private static Toast makeText(@NonNull Context context, @NonNull CharSequence message, int duration) {
        return MToast.make(null, context, message, duration);
    }

    private static Toast make(MToastConfig config, @NonNull Context context, @NonNull CharSequence message, int duration) {
        if (currentToast == null) {
            currentToast = new Toast(context);
        }
        View toastLayout = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(R.layout.mn_toast_layout, null);
        tvShowToast = (TextView)toastLayout.findViewById(R.id.tvShowToast);
        ivLeftShow = (ImageView)toastLayout.findViewById(R.id.ivLeftShow);
        toastBackgroundView = (LinearLayout)toastLayout.findViewById(R.id.toastBackgroundView);
        currentToast.setView(toastLayout);
        if (config == null) {
            config = new MToastConfig.Builder().build();
        }
        MToastConfig.MToastGravity ToastGravity = config.ToastGravity;
        int ToastTextColor = config.ToastTextColor;
        int ToastBackgroundColor = config.ToastBackgroundColor;
        float ToastBackgroundCornerRadius = config.ToastBackgroundCornerRadius;
        Drawable ToastIcon = config.ToastIcon;
        int ToastBackgroundStrokeColor = config.ToastBackgroundStrokeColor;
        float ToastBackgroundStrokeWidth = config.ToastBackgroundStrokeWidth;
        if (ToastIcon == null) {
            ivLeftShow.setVisibility(8);
        } else {
            ivLeftShow.setVisibility(0);
            ivLeftShow.setImageDrawable(ToastIcon);
        }
        tvShowToast.setTextColor(ToastTextColor);
        GradientDrawable myGrad = new GradientDrawable();
        myGrad.setCornerRadius((float)MToast.dip2px(context, ToastBackgroundCornerRadius));
        myGrad.setColor(ToastBackgroundColor);
        myGrad.setStroke(MToast.dip2px(context, ToastBackgroundStrokeWidth), ToastBackgroundStrokeColor);
        toastBackgroundView.setBackground((Drawable)myGrad);
        tvShowToast.setText(message);
        currentToast.setDuration(duration);
        if (ToastGravity == MToastConfig.MToastGravity.CENTRE) {
            currentToast.setGravity(17, 0, 0);
        } else {
            currentToast.setGravity(80, 0, MToast.dip2px(context, 80.0f));
        }
        return currentToast;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

