/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.maning.mndialoglibrary.MProgressDialog;
import com.maning.mndialoglibrary.R;

public class MStatusDialog {
    private Handler mHandler = new Handler();
    private Context mContext;
    private Dialog mDialog;
    private Builder mBuilder;
    private RelativeLayout dialog_window_background;
    private RelativeLayout dialog_view_bg;
    private ImageView imageStatus;
    private TextView tvShow;

    public MStatusDialog(Context context) {
        this(context, new Builder(context));
    }

    public MStatusDialog(Context context, Builder builder) {
        this.mContext = context;
        this.mBuilder = builder;
        this.initDialog();
    }

    private void initDialog() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View mProgressDialogView = inflater.inflate(R.layout.mn_status_dialog_layout, null);
        this.mDialog = new Dialog(this.mContext, R.style.MNCustomProgressDialog);
        this.mDialog.setCancelable(false);
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setContentView(mProgressDialogView);
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = ((Activity)this.mContext).getWindowManager();
        windowManager.getDefaultDisplay().getMetrics(dm);
        int screenW = dm.widthPixels;
        int screenH = dm.heightPixels;
        WindowManager.LayoutParams layoutParams = this.mDialog.getWindow().getAttributes();
        layoutParams.width = screenW;
        layoutParams.height = screenH;
        this.mDialog.getWindow().setAttributes(layoutParams);
        this.dialog_window_background = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_window_background);
        this.dialog_view_bg = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_view_bg);
        this.imageStatus = (ImageView)mProgressDialogView.findViewById(R.id.imageStatus);
        this.tvShow = (TextView)mProgressDialogView.findViewById(R.id.tvShow);
        this.configView();
    }

    private void configView() {
        this.dialog_window_background.setBackgroundColor(this.mBuilder.backgroundWindowColor);
        this.tvShow.setTextColor(this.mBuilder.textColor);
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setColor(this.mBuilder.backgroundViewColor);
        myGrad.setStroke(MProgressDialog.dip2px(this.mContext, this.mBuilder.strokeWidth), this.mBuilder.strokeColor);
        myGrad.setCornerRadius((float)MProgressDialog.dip2px(this.mContext, this.mBuilder.cornerRadius));
        this.dialog_view_bg.setBackground((Drawable)myGrad);
    }

    public void refreshBuilder(Builder builder) {
        this.mBuilder = builder;
        this.configView();
    }

    public void show(String msg, Drawable drawable) {
        this.show(msg, drawable, 2000L);
    }

    public void show(String msg, Drawable drawable, long delayMillis) {
        this.imageStatus.setImageDrawable(drawable);
        this.tvShow.setText((CharSequence)msg);
        this.mDialog.show();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                MStatusDialog.this.mDialog.dismiss();
                MStatusDialog.this.mHandler.removeCallbacksAndMessages(null);
            }
        }, delayMillis);
    }

    public static final class Builder {
        private Context mContext;
        int backgroundWindowColor;
        int backgroundViewColor;
        int strokeColor;
        float cornerRadius;
        float strokeWidth;
        int textColor;

        public Builder(Context context) {
            this.mContext = context;
            this.backgroundWindowColor = this.mContext.getResources().getColor(R.color.mn_colorDialogWindowBg);
            this.backgroundViewColor = this.mContext.getResources().getColor(R.color.mn_colorDialogViewBg);
            this.strokeColor = this.mContext.getResources().getColor(R.color.mn_colorDialogTrans);
            this.textColor = this.mContext.getResources().getColor(R.color.mn_colorDialogTextColor);
            this.cornerRadius = 6.0f;
            this.strokeWidth = 0.0f;
        }

        public MStatusDialog build() {
            return new MStatusDialog(this.mContext, this);
        }

        public Builder setBackgroundWindowColor(@Nullable int backgroundWindowColor) {
            this.backgroundWindowColor = backgroundWindowColor;
            return this;
        }

        public Builder setBackgroundViewColor(@Nullable int backgroundViewColor) {
            this.backgroundViewColor = backgroundViewColor;
            return this;
        }

        public Builder setStrokeColor(@Nullable int strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public Builder setStrokeWidth(@Nullable float strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Builder setCornerRadius(@Nullable float cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public Builder setTextColor(@Nullable int textColor) {
            this.textColor = textColor;
            return this;
        }
    }
}

