/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.utils.immersionbar;

import android.app.Application;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.maning.imagebrowserlibrary.utils.immersionbar.OSUtils;
import com.maning.imagebrowserlibrary.utils.immersionbar.OnNavigationBarListener;
import java.util.ArrayList;

final class NavigationBarObserver
extends ContentObserver {
    private ArrayList<OnNavigationBarListener> mListeners;
    private Application mApplication;
    private Boolean mIsRegister = false;

    static NavigationBarObserver getInstance() {
        return NavigationBarObserverInstance.INSTANCE;
    }

    private NavigationBarObserver() {
        super(new Handler(Looper.getMainLooper()));
    }

    void register(Application application) {
        this.mApplication = application;
        if (Build.VERSION.SDK_INT >= 17 && this.mApplication != null && this.mApplication.getContentResolver() != null && !this.mIsRegister.booleanValue()) {
            Uri uri = null;
            if (OSUtils.isMIUI()) {
                uri = Settings.Global.getUriFor((String)"force_fsg_nav_bar");
            } else if (OSUtils.isEMUI()) {
                uri = OSUtils.isEMUI3_x() || Build.VERSION.SDK_INT < 21 ? Settings.System.getUriFor((String)"navigationbar_is_min") : Settings.Global.getUriFor((String)"navigationbar_is_min");
            }
            if (uri != null) {
                this.mApplication.getContentResolver().registerContentObserver(uri, true, (ContentObserver)this);
                this.mIsRegister = true;
            }
        }
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        if (Build.VERSION.SDK_INT >= 17 && this.mApplication != null && this.mApplication.getContentResolver() != null && this.mListeners != null && !this.mListeners.isEmpty()) {
            int show = 0;
            if (OSUtils.isMIUI()) {
                show = Settings.Global.getInt((ContentResolver)this.mApplication.getContentResolver(), (String)"force_fsg_nav_bar", (int)0);
            } else if (OSUtils.isEMUI()) {
                show = OSUtils.isEMUI3_x() || Build.VERSION.SDK_INT < 21 ? Settings.System.getInt((ContentResolver)this.mApplication.getContentResolver(), (String)"navigationbar_is_min", (int)0) : Settings.Global.getInt((ContentResolver)this.mApplication.getContentResolver(), (String)"navigationbar_is_min", (int)0);
            }
            for (OnNavigationBarListener onNavigationBarListener : this.mListeners) {
                onNavigationBarListener.onNavigationBarChange(show != 1);
            }
        }
    }

    void addOnNavigationBarListener(OnNavigationBarListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    void removeOnNavigationBarListener(OnNavigationBarListener listener) {
        if (listener == null || this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    private static class NavigationBarObserverInstance {
        private static final NavigationBarObserver INSTANCE = new NavigationBarObserver();

        private NavigationBarObserverInstance() {
        }
    }
}

