/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.utils.immersionbar;

import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.content.res.Configuration;
import android.os.Build;
import androidx.fragment.app.DialogFragment;
import com.maning.imagebrowserlibrary.utils.immersionbar.BarConfig;
import com.maning.imagebrowserlibrary.utils.immersionbar.BarHide;
import com.maning.imagebrowserlibrary.utils.immersionbar.BarProperties;
import com.maning.imagebrowserlibrary.utils.immersionbar.ImmersionBar;
import com.maning.imagebrowserlibrary.utils.immersionbar.NotchUtils;
import com.maning.imagebrowserlibrary.utils.immersionbar.OSUtils;
import com.maning.imagebrowserlibrary.utils.immersionbar.OnBarListener;

class ImmersionDelegate
implements Runnable {
    private ImmersionBar mImmersionBar;
    private int mStatusBarHeight = 0;
    private BarProperties mBarProperties;
    private OnBarListener mOnBarListener;
    private int mNotchHeight;

    ImmersionDelegate(Object o) {
        if (o instanceof Activity) {
            if (this.mImmersionBar == null) {
                this.mImmersionBar = new ImmersionBar((Activity)o);
                this.mStatusBarHeight = ImmersionBar.getStatusBarHeight((Activity)o);
            }
        } else if (o instanceof androidx.fragment.app.Fragment) {
            if (this.mImmersionBar == null) {
                this.mImmersionBar = o instanceof DialogFragment ? new ImmersionBar((DialogFragment)o) : new ImmersionBar((androidx.fragment.app.Fragment)o);
                this.mStatusBarHeight = ImmersionBar.getStatusBarHeight((androidx.fragment.app.Fragment)o);
            }
        } else if (o instanceof Fragment && this.mImmersionBar == null) {
            this.mImmersionBar = o instanceof android.app.DialogFragment ? new ImmersionBar((android.app.DialogFragment)o) : new ImmersionBar((Fragment)o);
            this.mStatusBarHeight = ImmersionBar.getStatusBarHeight((Fragment)o);
        }
    }

    ImmersionDelegate(Activity activity, Dialog dialog) {
        if (this.mImmersionBar == null) {
            this.mImmersionBar = new ImmersionBar(activity, dialog);
            this.mStatusBarHeight = ImmersionBar.getStatusBarHeight(activity);
        }
    }

    public ImmersionBar get() {
        return this.mImmersionBar;
    }

    void onActivityCreated(Configuration configuration) {
        this.barChanged(configuration);
    }

    void onResume() {
        if (this.mImmersionBar != null && !this.mImmersionBar.isFragment() && this.mImmersionBar.initialized()) {
            if (OSUtils.isEMUI3_x() && this.mImmersionBar.getBarParams().navigationBarWithEMUI3Enable) {
                this.reinitialize();
            } else if (this.mImmersionBar.getBarParams().barHide != BarHide.FLAG_SHOW_BAR) {
                this.mImmersionBar.setBar();
            }
        }
    }

    void onDestroy() {
        this.mBarProperties = null;
        if (this.mImmersionBar != null) {
            this.mImmersionBar.destroy();
            this.mImmersionBar = null;
        }
    }

    void onConfigurationChanged(Configuration newConfig) {
        if (this.mImmersionBar != null) {
            if (OSUtils.isEMUI3_x() || Build.VERSION.SDK_INT == 19) {
                if (this.mImmersionBar.initialized() && !this.mImmersionBar.isFragment() && this.mImmersionBar.getBarParams().navigationBarWithKitkatEnable) {
                    this.reinitialize();
                } else {
                    this.fitsWindows();
                }
            } else {
                this.fitsWindows();
            }
            this.barChanged(newConfig);
        }
    }

    private void reinitialize() {
        if (this.mImmersionBar != null) {
            this.mImmersionBar.init();
        }
    }

    private void fitsWindows() {
        int statusBarHeight = ImmersionBar.getStatusBarHeight(this.mImmersionBar.getActivity());
        if (this.mStatusBarHeight != statusBarHeight) {
            this.mImmersionBar.fitsWindows();
            this.mStatusBarHeight = statusBarHeight;
        }
    }

    private void barChanged(Configuration configuration) {
        if (this.mImmersionBar != null && this.mImmersionBar.initialized() && Build.VERSION.SDK_INT >= 19) {
            this.mOnBarListener = this.mImmersionBar.getBarParams().onBarListener;
            if (this.mOnBarListener != null) {
                Activity activity = this.mImmersionBar.getActivity();
                if (this.mBarProperties == null) {
                    this.mBarProperties = new BarProperties();
                }
                this.mBarProperties.setPortrait(configuration.orientation == 1);
                int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
                if (rotation == 1) {
                    this.mBarProperties.setLandscapeLeft(true);
                    this.mBarProperties.setLandscapeRight(false);
                } else if (rotation == 3) {
                    this.mBarProperties.setLandscapeLeft(false);
                    this.mBarProperties.setLandscapeRight(true);
                } else {
                    this.mBarProperties.setLandscapeLeft(false);
                    this.mBarProperties.setLandscapeRight(false);
                }
                activity.getWindow().getDecorView().post((Runnable)this);
            }
        }
    }

    @Override
    public void run() {
        if (this.mImmersionBar != null && this.mImmersionBar.getActivity() != null) {
            Activity activity = this.mImmersionBar.getActivity();
            BarConfig barConfig = new BarConfig(activity);
            this.mBarProperties.setStatusBarHeight(barConfig.getStatusBarHeight());
            this.mBarProperties.setNavigationBar(barConfig.hasNavigationBar());
            this.mBarProperties.setNavigationBarHeight(barConfig.getNavigationBarHeight());
            this.mBarProperties.setNavigationBarWidth(barConfig.getNavigationBarWidth());
            this.mBarProperties.setActionBarHeight(barConfig.getActionBarHeight());
            boolean notchScreen = NotchUtils.hasNotchScreen(activity);
            this.mBarProperties.setNotchScreen(notchScreen);
            if (notchScreen && this.mNotchHeight == 0) {
                this.mNotchHeight = NotchUtils.getNotchHeight(activity);
                this.mBarProperties.setNotchHeight(this.mNotchHeight);
            }
            this.mOnBarListener.onBarChange(this.mBarProperties);
        }
    }
}

